/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLInteger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class AS400JDBCArrayResultSet
implements ResultSet {
    private int holdability_;
    private int concurrency_;
    private int fetchDirection_;
    private int fetchSize_;
    private int type_;
    private Object[][] data_;
    private int numberOfColumns_;
    private int numberOfRows_;
    private HashMap columnNameToIndexCache_;
    private SQLData contentTemplate_;
    private boolean isSQLData_;
    private int vrm_;
    private boolean openOnClient_;
    private int currentRowInRowset_;
    private int wasNull_;
    private Calendar calendar_;
    private Class byteArrayClass_;
    private static final int WAS_NULL_UNSET = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Object;

    AS400JDBCArrayResultSet(Object[] objectArray, SQLData sQLData, boolean bl, int n, int n2) {
        int n3;
        Object[][] objectArray2 = new Object[2][];
        if (bl) {
            objectArray2[0] = new SQLInteger[objectArray.length];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                try {
                    SQLInteger sQLInteger = (SQLInteger)SQLDataFactory.newData("INTEGER", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 37, null, this.vrm_, null);
                    objectArray2[0][n3] = sQLInteger;
                    ((SQLInteger)objectArray2[0][n3]).set(n3 + 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            objectArray2[0] = new Integer[objectArray.length];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                try {
                    objectArray2[0][n3] = new Integer(n3 + 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        objectArray2[1] = objectArray;
        this.contentTemplate_ = sQLData;
        this.isSQLData_ = bl;
        this.vrm_ = n2;
        String[] stringArray = new String[]{"INDEX", "VALUE"};
        this.init(1007, 1004, 1000, 1, objectArray2, stringArray);
    }

    void init(int n, int n2, int n3, int n4, Object[][] objectArray, String[] stringArray) {
        this.holdability_ = 1;
        this.concurrency_ = n;
        this.fetchDirection_ = n3;
        this.fetchSize_ = n4;
        this.type_ = n2;
        this.data_ = objectArray;
        this.numberOfColumns_ = objectArray.length;
        if (this.numberOfColumns_ > 0) {
            this.numberOfRows_ = objectArray[0].length;
        }
        this.columnNameToIndexCache_ = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNameToIndexCache_.put(stringArray[i], new Integer(i + 1));
        }
        this.openOnClient_ = true;
        this.currentRowInRowset_ = -1;
    }

    public void close() throws SQLException {
        this.openOnClient_ = false;
    }

    private Calendar getCalendar(TimeZone timeZone) {
        this.calendar_ = this.calendar_ != null ? this.calendar_ : new GregorianCalendar();
        this.calendar_.setTimeZone(timeZone);
        return this.calendar_;
    }

    private final void checkThatResultSetTypeIsScrollable() throws SQLException {
        if (this.type_ == 1003) {
            JDError.throwSQLException("24000");
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == -1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isBeforeFirst");
        }
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == this.numberOfRows_;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isAfterLast");
        }
        return bl;
    }

    public boolean isFirst() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isFirst");
        }
        return bl;
    }

    public boolean isLast() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == this.numberOfRows_ - 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isLast");
        }
        return bl;
    }

    public void beforeFirst() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "beforeFirst");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = -1;
    }

    public void afterLast() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "afterLast");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = this.numberOfRows_;
    }

    public boolean first() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            bl = false;
        } else {
            bl = true;
            this.currentRowInRowset_ = 0;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "first");
        }
        return bl;
    }

    public boolean last() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            bl = false;
        } else {
            bl = true;
            this.currentRowInRowset_ = this.numberOfRows_ - 1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "last");
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        --this.currentRowInRowset_;
        if (this.currentRowInRowset_ >= 0) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = -1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "previous");
        }
        return bl;
    }

    public boolean next() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.wasNull_ = 0;
        ++this.currentRowInRowset_;
        if (this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.numberOfRows_;
        }
        if (!bl && this.type_ == 1003) {
            this.close();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "next");
        }
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = n >= 0 ? n - 1 : n + this.numberOfRows_;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "absolute");
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ += n;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "relative");
        }
        return bl;
    }

    public int getConcurrency() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConcurrency");
        }
        this.checkForClosedResultSet();
        return this.concurrency_;
    }

    public int getType() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getType");
        }
        this.checkForClosedResultSet();
        return this.type_;
    }

    public int getFetchDirection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchDirection");
        }
        this.checkForClosedResultSet();
        return this.fetchDirection_;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchDirection");
        }
        this.checkForClosedResultSet();
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection_ = n;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
            }
        }
    }

    public int getFetchSize() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchSize");
        }
        this.checkForClosedResultSet();
        return this.fetchSize_;
    }

    public void setFetchSize(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchSize");
        }
        this.checkForClosedResultSet();
        if (n < 0) {
            JDError.throwSQLException("HY024");
        }
        this.fetchSize_ = n;
    }

    public String getCursorName() throws SQLException {
        String string = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCursorName");
        }
        this.checkForClosedResultSet();
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getMetaData");
        }
        this.checkForClosedResultSet();
        return resultSetMetaData;
    }

    public Statement getStatement() throws SQLException {
        Statement statement = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getStatement");
        }
        this.checkForClosedResultSet();
        return statement;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getWarnings");
        }
        this.checkForClosedResultSet();
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "clearWarnings");
        }
        this.checkForClosedResultSet();
    }

    public int findColumn(String string) throws SQLException {
        this.checkForClosedResultSet();
        int n = this.findColumnX(string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "findColumn");
        }
        return n;
    }

    private final int findColumnX(String string) throws SQLException {
        Integer n = (Integer)this.columnNameToIndexCache_.get(string.toUpperCase());
        if (n != null) {
            return n;
        }
        JDError.throwSQLException("HY024");
        return -1;
    }

    public int getRow() throws SQLException {
        this.checkForClosedResultSet();
        int n = this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1 ? this.currentRowInRowset_ + 1 : 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRow");
        }
        return n;
    }

    public boolean wasNull() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        if (this.wasNull_ == 0) {
            JDError.throwSQLException("HY109");
        }
        boolean bl2 = bl = this.wasNull_ == 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "wasNull");
        }
        return bl;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        boolean bl = false;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                bl = ((SQLData)objectArray[this.currentRowInRowset_]).getBoolean();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            bl = this.contentTemplate_.getBoolean();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        return this.getBoolean(this.findColumnX(string));
    }

    public byte getByte(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        byte by = 0;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                by = ((SQLData)objectArray[this.currentRowInRowset_]).getByte();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            by = this.contentTemplate_.getByte();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return by;
    }

    public byte getByte(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        return this.getByte(this.findColumnX(string));
    }

    public short getShort(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        short s = 0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                s = ((SQLData)objectArray[this.currentRowInRowset_]).getShort();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            s = this.contentTemplate_.getShort();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return s;
    }

    public short getShort(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        return this.getShort(this.findColumnX(string));
    }

    public int getInt(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        int n2 = 0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                n2 = ((SQLData)objectArray[this.currentRowInRowset_]).getInt();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            n2 = this.contentTemplate_.getInt();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return n2;
    }

    public int getInt(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        return this.getInt(this.findColumnX(string));
    }

    public long getLong(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        long l = 0L;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                l = ((SQLData)objectArray[this.currentRowInRowset_]).getLong();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            l = this.contentTemplate_.getLong();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return l;
    }

    public long getLong(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        return this.getLong(this.findColumnX(string));
    }

    public float getFloat(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        float f = 0.0f;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                f = ((SQLData)objectArray[this.currentRowInRowset_]).getFloat();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            f = this.contentTemplate_.getFloat();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return f;
    }

    public float getFloat(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        return this.getFloat(this.findColumnX(string));
    }

    public double getDouble(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        double d = 0.0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                d = ((SQLData)objectArray[this.currentRowInRowset_]).getDouble();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            d = this.contentTemplate_.getDouble();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return d;
    }

    public double getDouble(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        return this.getDouble(this.findColumnX(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        BigDecimal bigDecimal = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                bigDecimal = ((SQLData)objectArray[this.currentRowInRowset_]).getBigDecimal(-1);
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            bigDecimal = this.contentTemplate_.getBigDecimal(-1);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        return this.getBigDecimal(this.findColumnX(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + n + " " + n2);
        }
        return this.getBigDecimal(n).setScale(n2);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + string + " " + n);
        }
        return this.getBigDecimal(this.findColumnX(string), n);
    }

    public synchronized Date getDate(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDateX(n, TimeZone.getDefault());
    }

    public Date getDate(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDate(this.findColumnX(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTimeX(n, TimeZone.getDefault());
    }

    public Time getTime(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(string));
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestampX(n, TimeZone.getDefault());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(string));
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + n);
        }
        Date date = this.getDateX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return date;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + string);
        }
        return this.getDate(this.findColumnX(string), calendar);
    }

    private Date getDateX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Date date = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                date = ((SQLData)objectArray[this.currentRowInRowset_]).getDate(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            date = this.contentTemplate_.getDate(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return date;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return time;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(string), calendar);
    }

    private Time getTimeX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Time time = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                time = ((SQLData)objectArray[this.currentRowInRowset_]).getTime(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            time = this.contentTemplate_.getTime(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return time;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestampX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(string), calendar);
    }

    private Timestamp getTimestampX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Timestamp timestamp = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                timestamp = ((SQLData)objectArray[this.currentRowInRowset_]).getTimestamp(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            timestamp = this.contentTemplate_.getTimestamp(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return timestamp;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        byte[] byArray = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                byArray = ((SQLData)objectArray[this.currentRowInRowset_]).getBytes();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            byArray = this.contentTemplate_.getBytes();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        return this.getBytes(this.findColumnX(string));
    }

    public synchronized String getString(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        String string = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return string;
    }

    public String getString(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        return this.getString(this.findColumnX(string));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getBinaryStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getBinaryStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        return this.getBinaryStream(this.findColumnX(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getAsciiStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getAsciiStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        return this.getAsciiStream(this.findColumnX(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getUnicodeStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getUnicodeStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        return this.getUnicodeStream(this.findColumnX(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Reader reader = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                reader = ((SQLData)objectArray[this.currentRowInRowset_]).getCharacterStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            reader = this.contentTemplate_.getCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return reader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        return this.getCharacterStream(this.findColumnX(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Blob blob = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                blob = ((SQLData)objectArray[this.currentRowInRowset_]).getBlob();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            blob = this.contentTemplate_.getBlob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return blob;
    }

    public Blob getBlob(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        return this.getBlob(this.findColumnX(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Clob clob = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                clob = ((SQLData)objectArray[this.currentRowInRowset_]).getClob();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            clob = this.contentTemplate_.getClob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return clob;
    }

    public Clob getClob(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        return this.getClob(this.findColumnX(string));
    }

    public Array getArray(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public URL getURL(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        URL uRL = null;
        Object[] objectArray = this.data_[n - 1];
        String string = null;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getString();
        }
        try {
            uRL = string == null ? null : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JDError.throwSQLException("HY105", malformedURLException);
            uRL = null;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return uRL;
    }

    public URL getURL(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        return this.getURL(this.findColumnX(string));
    }

    public Object getObject(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        Object object = null;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                object = ((SQLData)objectArray[this.currentRowInRowset_]).getObject();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            object = this.contentTemplate_.getObject();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return object;
    }

    public Object getObject(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        return this.getObject(this.findColumnX(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public void updateNull(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNull(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.updateNull(this.findColumnX(string));
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateByte(String string, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.updateByte(this.findColumnX(string), by);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.updateBoolean(this.findColumnX(string), bl);
    }

    public void updateShort(int n, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateShort(String string, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.updateShort(this.findColumnX(string), s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateInt(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.updateInt(this.findColumnX(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateLong(String string, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.updateLong(this.findColumnX(string), l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateFloat(String string, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.updateFloat(this.findColumnX(string), f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateDouble(String string, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.updateDouble(this.findColumnX(string), d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.updateBigDecimal(this.findColumnX(string), bigDecimal);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateDate(String string, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.updateDate(this.findColumnX(string), date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateTime(String string, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.updateTime(this.findColumnX(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.updateTimestamp(this.findColumnX(string), timestamp);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.updateBytes(this.findColumnX(string), byArray);
    }

    public void updateString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.updateString(this.findColumnX(string), string2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream, n);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateArray(String string, Array array) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.updateArray(this.findColumnX(string), array);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.updateRef(this.findColumnX(string), ref);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(string), object, n);
    }

    public boolean rowUpdated() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowInserted()");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowDeleted()");
        return false;
    }

    public void insertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "insertRow");
    }

    public void updateRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "updateRow()");
    }

    public void deleteRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "deleteRow()");
    }

    public void refreshRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "refreshRow()");
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "cancelRowUpdates()");
    }

    public void moveToInsertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToInsertRow()");
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToCurrentRow()");
    }

    private final void checkForClosedResultSet() throws SQLException {
        if (!this.openOnClient_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.numberOfColumns_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidPosition() throws SQLException {
        if (this.currentRowInRowset_ < 0 || this.currentRowInRowset_ > this.numberOfRows_ - 1) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForConcurrency() throws SQLException {
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkGetterPreconditions(int n) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        this.checkForValidPosition();
    }

    private final void checkUpdatePreconditions(int n) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        this.checkForConcurrency();
    }

    private final void checkUpdatePreconditions() throws SQLException {
        this.checkForClosedResultSet();
        this.checkForConcurrency();
    }

    public boolean isClosed() throws SQLException {
        return !this.openOnClient_;
    }

    public int getHoldability() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getHoldability");
        }
        this.checkForClosedResultSet();
        return this.holdability_;
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Reader reader = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                reader = ((SQLData)objectArray[this.currentRowInRowset_]).getNCharacterStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            reader = this.contentTemplate_.getNCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return reader;
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        return this.getNCharacterStream(this.findColumnX(string));
    }

    public String getNString(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        String string = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getNString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getNString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return string;
    }

    public String getNString(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        return this.getNString(this.findColumnX(string));
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream);
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream, l);
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream);
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream, l);
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), inputStream);
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), inputStream, l);
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader);
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader, l);
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), reader);
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), reader, l);
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(string), reader);
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(string), reader, l);
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(string), reader);
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(string), reader, l);
    }

    public void updateNString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.checkUpdatePreconditions(n);
    }

    public void updateNString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.updateNString(this.findColumnX(string), string2);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if (clazz == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byArray = new byte[1];
            this.byteArrayClass_ = byArray.getClass();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AS400JDBCArrayResultSet.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getString(n);
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = AS400JDBCArrayResultSet.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            byte by = this.getByte(n);
            if (by == 0 && this.wasNull()) {
                return null;
            }
            return new Byte(by);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = AS400JDBCArrayResultSet.class$("java.lang.Short")) : class$java$lang$Short)) {
            short s = this.getShort(n);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = AS400JDBCArrayResultSet.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            int n2 = this.getInt(n);
            if (n2 == 0 && this.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = AS400JDBCArrayResultSet.class$("java.lang.Long")) : class$java$lang$Long)) {
            long l = this.getLong(n);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = AS400JDBCArrayResultSet.class$("java.lang.Float")) : class$java$lang$Float)) {
            float f = this.getFloat(n);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = AS400JDBCArrayResultSet.class$("java.lang.Double")) : class$java$lang$Double)) {
            double d = this.getDouble(n);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400JDBCArrayResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return this.getBigDecimal(n);
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AS400JDBCArrayResultSet.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            boolean bl = this.getBoolean(n);
            if (!bl && this.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }
        if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = AS400JDBCArrayResultSet.class$("java.sql.Date")) : class$java$sql$Date)) {
            return this.getDate(n);
        }
        if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = AS400JDBCArrayResultSet.class$("java.sql.Time")) : class$java$sql$Time)) {
            return this.getTime(n);
        }
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = AS400JDBCArrayResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return this.getTimestamp(n);
        }
        if (clazz == this.byteArrayClass_) {
            return this.getBytes(n);
        }
        if (clazz == (class$java$io$InputStream == null ? (class$java$io$InputStream = AS400JDBCArrayResultSet.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            return this.getBinaryStream(n);
        }
        if (clazz == (class$java$io$Reader == null ? (class$java$io$Reader = AS400JDBCArrayResultSet.class$("java.io.Reader")) : class$java$io$Reader)) {
            return this.getCharacterStream(n);
        }
        if (clazz == (class$java$sql$Clob == null ? (class$java$sql$Clob = AS400JDBCArrayResultSet.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return this.getClob(n);
        }
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = AS400JDBCArrayResultSet.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return this.getBlob(n);
        }
        if (clazz == (class$java$sql$Array == null ? (class$java$sql$Array = AS400JDBCArrayResultSet.class$("java.sql.Array")) : class$java$sql$Array)) {
            return this.getArray(n);
        }
        if (clazz == (class$java$sql$Ref == null ? (class$java$sql$Ref = AS400JDBCArrayResultSet.class$("java.sql.Ref")) : class$java$sql$Ref)) {
            return this.getRef(n);
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AS400JDBCArrayResultSet.class$("java.net.URL")) : class$java$net$URL)) {
            return this.getURL(n);
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AS400JDBCArrayResultSet.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getObject(n);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findColumnX(string), clazz);
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCArrayResultSet", "java.sql.ResultSet"};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

