/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class AS400JDBCResultSet
implements ResultSet {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final int HOLDABILITY_NOT_SPECIFIED = -9999;
    static final int HOLD_CURSORS_OVER_COMMIT = 1;
    static final int CLOSE_CURSORS_AT_COMMIT = 2;
    private String catalog_;
    private boolean closed_;
    private int columnCount_;
    private int concurrency_;
    private AS400JDBCConnection connection_;
    private String correlationName_;
    private String cursorName_;
    private boolean dataTruncation_;
    private PreparedStatement deleteStatement_;
    private int fetchDirection_;
    private int fetchSize_;
    private AS400JDBCStatementLock internalLock_;
    private int maxRows_;
    private InputStream openInputStream_;
    private Reader openReader_;
    private JDRow row_;
    private JDRowCache rowCache_;
    private String selectTable_;
    private SQLWarning sqlWarning_;
    private AS400JDBCStatement statement_;
    private int type_;
    private boolean[] updateNulls_;
    private boolean[] updateDefaults_;
    private boolean[] updateUnassigned_;
    private JDRow updateRow_;
    private boolean[] updateSet_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    boolean isMetadataResultSet = false;
    private DBReplyRequestedDS reply_ = null;
    private Class byteArrayClass_ = null;
    private SQLException savedException_;
    DBExtendedColumnDescriptors extendedDescriptors_;
    SQLConversionSettings settings_;
    private static final int NOT_KNOWN = -9999;
    private int positionFromFirst_ = 0;
    private int positionFromLast_ = -1;
    private boolean positionInsert_ = false;
    private boolean positionValid_ = false;
    private int totalRows_ = -9999;
    private int highestKnownRow_ = -9999;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Object;

    AS400JDBCResultSet(AS400JDBCStatement aS400JDBCStatement, JDSQLStatement jDSQLStatement, JDRowCache jDRowCache, String string, String string2, int n, int n2, int n3, int n4, int n5, DBExtendedColumnDescriptors dBExtendedColumnDescriptors) throws SQLException {
        this.catalog_ = string;
        this.closed_ = false;
        this.concurrency_ = n3;
        this.connection_ = (AS400JDBCConnection)(aS400JDBCStatement != null ? aS400JDBCStatement.getConnection() : null);
        this.settings_ = this.connection_ != null ? SQLConversionSettings.getConversionSettings(this.connection_) : null;
        this.cursorName_ = string2;
        this.deleteStatement_ = null;
        this.fetchDirection_ = n4;
        this.fetchSize_ = n5;
        this.internalLock_ = aS400JDBCStatement != null ? aS400JDBCStatement.getInternalLock() : new AS400JDBCStatementLock();
        this.maxRows_ = n;
        this.openInputStream_ = null;
        this.openReader_ = null;
        this.row_ = jDRowCache.getRow();
        this.rowCache_ = jDRowCache;
        this.sqlWarning_ = null;
        this.statement_ = aS400JDBCStatement;
        this.type_ = n2;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
        this.columnCount_ = this.row_.getFieldCount();
        this.rowCache_.setResultSet(this);
        this.rowCache_.open();
        this.extendedDescriptors_ = dBExtendedColumnDescriptors;
        if (this.connection_ == null || jDSQLStatement == null || this.connection_.getMustSpecifyForUpdate() && !jDSQLStatement.isForUpdate()) {
            this.selectTable_ = null;
            this.correlationName_ = null;
            this.concurrency_ = 1007;
        } else {
            this.selectTable_ = jDSQLStatement.getSelectTable();
            this.correlationName_ = jDSQLStatement.getCorrelationName();
        }
        if (this.concurrency_ == 1008) {
            this.updateRow_ = new JDSimpleRow(this.row_, true);
            this.updateSet_ = new boolean[this.columnCount_];
            this.updateNulls_ = new boolean[this.columnCount_];
            this.updateDefaults_ = new boolean[this.columnCount_];
            this.updateUnassigned_ = new boolean[this.columnCount_];
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
                this.updateNulls_[i] = true;
            }
        }
        this.dataTruncation_ = this.connection_ != null ? this.connection_.getProperties().getBoolean(33) : false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, this.statement_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Conncurrency", this.concurrency_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch direction", this.fetchDirection_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Fetch size", this.fetchSize_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Max rows", this.maxRows_);
            JDTrace.logProperty((Object)this, "AS400JDBCResultSet", "Type", this.type_);
        }
    }

    AS400JDBCResultSet(JDRowCache jDRowCache, String string, String string2, AS400JDBCConnection aS400JDBCConnection, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
        this(null, null, jDRowCache, string, string2, 0, 1004, 1007, 1000, 0, dBReplyRequestedDS == null ? null : dBReplyRequestedDS.getExtendedColumnDescriptors());
        this.reply_ = dBReplyRequestedDS;
        if (aS400JDBCConnection != null) {
            this.connection_ = aS400JDBCConnection;
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed_) {
            JDError.throwSQLException("24000");
        }
    }

    private void clearCurrentRow() throws SQLException {
        this.clearCurrentValue();
        this.clearWarnings();
        if (this.concurrency_ == 1008) {
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateNulls_[i] = true;
                this.updateDefaults_[i] = false;
                this.updateUnassigned_[i] = false;
                this.updateSet_[i] = false;
            }
        }
    }

    private void clearCurrentValue() {
        if (this.openInputStream_ != null) {
            try {
                this.openInputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openInputStream_ = null;
        }
        if (this.openReader_ != null) {
            try {
                this.openReader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openReader_ = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.isClosed()) {
                return;
            }
            this.rowCache_.close();
            if (this.reply_ != null) {
                this.reply_.returnToPool();
                this.reply_ = null;
            }
            this.closed_ = true;
            if (this.statement_ != null) {
                this.statement_.notifyClose();
            }
            if (this.deleteStatement_ != null) {
                this.deleteStatement_.close();
            }
            if (this.isMetadataResultSet) {
                this.statement_.close();
            }
            if (JDTrace.isTraceOn()) {
                SQLException sQLException = new SQLException("Cursor was closed here");
                JDTrace.logException(this, "Closing info", sQLException);
                JDTrace.logClose(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed_) {
                JDTrace.logInformation(this, "WARNING: Finalizer thread closing result set object.");
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.row_.findField(string != null ? string : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor jDCursor = this.statement_.getCursor();
                if (jDCursor.getCursorAttributeUpdatable() == 0) {
                    return 1007;
                }
                if (jDCursor.getCursorAttributeUpdatable() == 1) {
                    return 1008;
                }
                return this.concurrency_;
            }
            return this.concurrency_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.cursorName_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchDirection_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.fetchSize_;
        }
    }

    JDRowCache getRowCache() {
        return this.rowCache_;
    }

    public Statement getStatement() throws SQLException {
        if (this.isMetadataResultSet) {
            return null;
        }
        return this.statement_;
    }

    void setStatement(AS400JDBCStatement aS400JDBCStatement) {
        this.statement_ = aS400JDBCStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.type_ == 1003) {
                return 1003;
            }
            if (this.statement_ != null) {
                JDCursor jDCursor = this.statement_.getCursor();
                if (jDCursor.getCursorAttributeScrollable() == 0) {
                    return 1003;
                }
                if (jDCursor.getCursorAttributeSensitive() == 0) {
                    return 1004;
                }
                if (jDCursor.getCursorAttributeSensitive() == 1) {
                    return 1005;
                }
                return this.type_;
            }
            return this.type_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            try {
                String string = this.getString(n);
                if (string == null) {
                    return null;
                }
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                JDError.throwSQLException("07006", malformedURLException);
                return null;
            }
        }
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    void postWarning(SQLWarning sQLWarning) {
        try {
            if (this.statement_ != null && this.statement_.getConnection() != null && ((AS400JDBCConnection)this.statement_.getConnection()).ignoreWarning(sQLWarning)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sQLWarning;
        } else {
            this.sqlWarning_.setNextWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (n != 1000 && n != 1001 && n != 1002 || this.getType() == 1003 && n != 1000) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchDirection_ = n;
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchDirection", "Fetch direction", this.fetchDirection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (n < 0 || n > this.maxRows_ && this.maxRows_ > 0) {
                JDError.throwSQLException("HY024");
            }
            this.checkOpen();
            this.fetchSize_ = n;
            if (this.rowCache_ instanceof JDServerRowCache) {
                ((JDServerRowCache)this.rowCache_).setFetchSize(this.fetchSize_);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logProperty((Object)this, "setFetchSize", "Fetch size", this.fetchSize_);
            }
        }
    }

    public String toString() {
        return this.cursorName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            int n2;
            if (n == 0) {
                this.beforeFirst();
                return false;
            }
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                if (n > 0) {
                    if (n > this.maxRows_) {
                        this.afterLast();
                        return false;
                    }
                } else {
                    if (this.totalRows_ == -9999) {
                        this.findLastRow();
                    }
                    if ((n2 = this.totalRows_ + n) < 0) {
                        this.beforeFirst();
                        return false;
                    }
                    n = n2 + 1;
                }
            }
            this.rowCache_.absolute(n);
            this.positionValid_ = this.rowCache_.isValid();
            if (n > 0) {
                this.positionFromFirst_ = this.positionValid_ ? n : -1;
                int n3 = this.positionFromLast_ = this.positionValid_ ? -1 : 0;
                if (this.positionValid_) {
                    if (this.highestKnownRow_ < n) {
                        this.highestKnownRow_ = n;
                    }
                    if (this.totalRows_ != -9999) {
                        this.positionFromLast_ = this.totalRows_ - n + 1;
                    }
                }
            } else {
                this.positionFromFirst_ = this.positionValid_ ? -1 : 0;
                int n4 = this.positionFromLast_ = this.positionValid_ ? -n : -1;
                if (this.positionValid_ && this.totalRows_ != -9999) {
                    n2 = this.totalRows_ + n;
                    if (this.highestKnownRow_ < n2) {
                        this.highestKnownRow_ = n2;
                    }
                    this.positionFromFirst_ = n2 + 1;
                }
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.last();
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.first();
            this.previous();
            this.positionFromLast_ = -1;
        }
    }

    private void beforePositioning(boolean bl) throws SQLException {
        if (this.savedException_ != null) {
            SQLException sQLException = this.savedException_;
            this.savedException_ = null;
            JDError.throwSQLException((Object)this, sQLException);
        }
        this.checkOpen();
        if (bl && this.getType() == 1003) {
            JDError.throwSQLException("24000");
        }
        this.clearCurrentRow();
        this.positionInsert_ = false;
    }

    private void findLastRow() throws SQLException {
        this.checkOpen();
        if (this.totalRows_ != -9999) {
            return;
        }
        if (this.highestKnownRow_ > 0) {
            if (this.highestKnownRow_ >= this.maxRows_) {
                this.highestKnownRow_ = this.maxRows_;
            } else {
                this.rowCache_.absolute(this.highestKnownRow_);
                this.rowCache_.next();
                while (this.rowCache_.isValid()) {
                    ++this.highestKnownRow_;
                    if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                        this.rowCache_.next();
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.rowCache_.first();
            if (!this.rowCache_.isValid()) {
                return;
            }
            this.highestKnownRow_ = 0;
            while (this.rowCache_.isValid()) {
                ++this.highestKnownRow_;
                if (this.maxRows_ <= 0 || this.highestKnownRow_ != this.maxRows_) {
                    this.rowCache_.next();
                    continue;
                }
                break;
            }
        }
        this.totalRows_ = this.highestKnownRow_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.rowCache_.first();
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = 1;
                this.positionFromLast_ = this.totalRows_ == -9999 ? -1 : this.totalRows_;
                this.positionValid_ = true;
                if (this.highestKnownRow_ < 1) {
                    this.highestKnownRow_ = 1;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.positionInsert_ || !this.positionValid_ || this.isBeforeFirst() || this.isAfterLast()) {
                return 0;
            }
            if (this.positionFromFirst_ > 0) {
                return this.positionFromFirst_;
            }
            if (this.isLast()) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                    return this.positionFromFirst_;
                }
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.previous();
                return this.positionFromFirst_;
            }
            if (this.positionFromLast_ > 0) {
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_ - this.positionFromLast_ + 1;
                    return this.positionFromFirst_;
                }
                int n = this.positionFromLast_;
                if (this.highestKnownRow_ == -9999) {
                    this.first();
                } else {
                    this.absolute(this.highestKnownRow_);
                }
                while (this.next()) {
                }
                this.absolute(this.totalRows_ - n + 1);
                return this.positionFromFirst_;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Could not determine row number in getRow().");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromLast_ == 0 && this.positionFromFirst_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromFirst_ == 0 && this.positionFromLast_ != 0 && !this.positionInsert_ && !this.rowCache_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.positionFromFirst_ == 1 && !this.positionInsert_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.positionInsert_ || this.positionFromLast_ > 1 || !this.positionValid_) {
                return false;
            }
            if (this.positionFromLast_ == 1 || this.positionFromFirst_ == this.maxRows_ && this.maxRows_ > 0) {
                return true;
            }
            boolean bl = !this.next();
            this.previous();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            if (this.maxRows_ > 0) {
                this.findLastRow();
                if (this.totalRows_ >= this.maxRows_) {
                    this.rowCache_.absolute(this.maxRows_);
                } else {
                    this.rowCache_.last();
                }
            } else {
                this.rowCache_.last();
            }
            if (this.rowCache_.isValid()) {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 1;
                this.positionValid_ = true;
                if (this.totalRows_ != -9999) {
                    this.positionFromFirst_ = this.totalRows_;
                }
            } else {
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = -1;
                this.positionValid_ = false;
                this.totalRows_ = 0;
                this.highestKnownRow_ = -9999;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.beforeUpdate();
            this.positionInsert_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(false);
            if (this.maxRows_ > 0 && this.positionFromFirst_ >= this.maxRows_) {
                block15: {
                    try {
                        this.rowCache_.absolute(this.maxRows_ + 1);
                    }
                    catch (Exception exception) {
                        if (!JDTrace.isTraceOn()) break block15;
                        JDTrace.logException(this, "Warning: Exception encountered on going to last  ", exception);
                    }
                }
                this.positionFromFirst_ = -1;
                this.positionFromLast_ = 0;
                this.positionValid_ = false;
                this.totalRows_ = this.maxRows_;
                this.highestKnownRow_ = this.maxRows_;
                return false;
            }
            this.rowCache_.next();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    ++this.positionFromFirst_;
                }
                if (this.positionFromLast_ > 0) {
                    --this.positionFromLast_;
                }
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
                this.positionValid_ = true;
            } else {
                if (!this.rowCache_.isEmpty()) {
                    if (this.positionFromLast_ != 0 && this.positionFromFirst_ >= 0) {
                        this.totalRows_ = this.positionFromFirst_++;
                    }
                    this.positionFromLast_ = 0;
                } else if (this.highestKnownRow_ > 0) {
                    this.positionFromFirst_ = this.totalRows_ = this.highestKnownRow_;
                    this.positionFromLast_ = 0;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            this.rowCache_.previous();
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ > 0) {
                    --this.positionFromFirst_;
                }
                if (this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionValid_ = true;
            } else {
                if (this.positionFromFirst_ != 0 && this.positionFromLast_ >= 0) {
                    ++this.positionFromLast_;
                }
                this.positionFromFirst_ = 0;
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            this.beforePositioning(true);
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.concurrency_ == 1008) {
                for (int i = 0; i < this.columnCount_; ++i) {
                    this.updateSet_[i] = false;
                }
            }
            this.rowCache_.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforePositioning(true);
            if (n < 0 && this.isBeforeFirst()) {
                return false;
            }
            if (this.maxRows_ > 0 && this.positionFromFirst_ == -1) {
                this.getRow();
            }
            if (this.positionFromFirst_ >= 0 && this.positionFromFirst_ + n > this.maxRows_ && this.maxRows_ > 0) {
                this.afterLast();
                return false;
            }
            this.rowCache_.relative(n);
            if (this.rowCache_.isValid()) {
                if (this.positionFromFirst_ >= 0) {
                    this.positionFromFirst_ += n;
                }
                if (this.positionFromLast_ >= 0) {
                    this.positionFromLast_ -= n;
                }
                this.positionValid_ = true;
                if (this.positionFromFirst_ >= 0 && this.highestKnownRow_ < this.positionFromFirst_) {
                    this.highestKnownRow_ = this.positionFromFirst_;
                }
            } else {
                if (n >= 0) {
                    this.positionFromFirst_ = -1;
                    this.positionFromLast_ = 0;
                } else {
                    this.positionFromFirst_ = 0;
                    this.positionFromLast_ = -1;
                }
                this.positionValid_ = false;
            }
            return this.positionValid_;
        }
    }

    public Array getArray(int n) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + n);
        return null;
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getAsciiStream();
            this.testDataTruncation(n, sQLData, false);
            return inputStream;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(-1);
            this.testDataTruncation(n, sQLData, false);
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY094", "" + n2);
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(n2);
            this.testDataTruncation(n, sQLData, false);
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getBinaryStream();
            this.testDataTruncation(n, sQLData, false);
            return inputStream;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Blob blob = sQLData == null ? null : sQLData.getBlob();
            this.testDataTruncation(n, sQLData, false);
            return blob;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            boolean bl = sQLData == null ? false : sQLData.getBoolean();
            this.testDataTruncation(n, sQLData, false);
            return bl;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            byte by = sQLData == null ? (byte)0 : sQLData.getByte();
            this.testDataTruncation(n, sQLData, true);
            return by;
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            byte[] byArray;
            SQLData sQLData = this.getValue(n);
            int n2 = 0;
            if (sQLData != null) {
                n2 = sQLData.getSQLType();
            }
            if (sQLData != null && n2 != 2 && n2 != 29 && n2 != 3 && n2 != 4 && n2 != 6 && n2 != 20 && n2 != 31 && n2 != 25 && n2 != 40 && this.row_ instanceof JDServerRow) {
                byArray = ((JDServerRow)this.row_).getRawBytes(n);
                if (n2 == 30 || n2 == 32 || n2 == 36 || n2 == 9) {
                    if (byArray != null && byArray.length >= 2) {
                        int n3 = 256 * (byArray[0] & 0xFF) + (byArray[1] & 0xFF);
                        if (n2 == 32 || n2 == 36) {
                            n3 *= 2;
                        }
                        byte[] byArray2 = new byte[n3];
                        for (int i = 0; i < n3; ++i) {
                            byArray2[i] = byArray[i + 2];
                        }
                        byArray = byArray2;
                    }
                } else if (n2 == 8) {
                    String string = sQLData.getString();
                    try {
                        byArray = string.getBytes("ISO8859_1");
                    }
                    catch (Exception exception) {}
                } else if (n2 == 12 || n2 == 34) {
                    String string = sQLData.getString();
                    try {
                        byArray = string.getBytes("UTF-16BE");
                    }
                    catch (Exception exception) {}
                }
            } else {
                byArray = sQLData == null ? null : sQLData.getBytes();
                this.testDataTruncation(n, sQLData, false);
            }
            return byArray;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            Reader reader;
            SQLData sQLData = this.getValue(n);
            this.openReader_ = reader = sQLData == null ? null : sQLData.getCharacterStream();
            this.testDataTruncation(n, sQLData, false);
            return reader;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Clob clob = sQLData == null ? null : sQLData.getClob();
            this.testDataTruncation(n, sQLData, false);
            return clob;
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        return this.internalGetDate(n, null);
    }

    public Date getDate(String string) throws SQLException {
        return this.internalGetDate(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date internalGetDate(int n, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Date date = sQLData == null ? null : sQLData.getDate(calendar);
            this.testDataTruncation(n, sQLData, false);
            return date;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            double d = sQLData == null ? 0.0 : sQLData.getDouble();
            this.testDataTruncation(n, sQLData, true);
            return d;
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            float f = sQLData == null ? 0.0f : sQLData.getFloat();
            this.testDataTruncation(n, sQLData, true);
            return f;
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            int n2 = sQLData == null ? 0 : sQLData.getInt();
            this.testDataTruncation(n, sQLData, true);
            return n2;
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            long l = sQLData == null ? 0L : sQLData.getLong();
            this.testDataTruncation(n, sQLData, true);
            return l;
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            ConvTable convTable = null;
            if (this.extendedDescriptors_ != null) {
                convTable = this.connection_.getConverter();
            }
            return new AS400JDBCResultSetMetaData(this.catalog_, this.concurrency_, this.cursorName_, this.row_, this.extendedDescriptors_, convTable, this.connection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Object object = sQLData == null ? null : sQLData.getObject();
            this.testDataTruncation(n, sQLData, false);
            return object;
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (map == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (map == null) {
            JDError.throwSQLException("HY024");
        }
        return this.getObject(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + n);
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            short s = sQLData == null ? (short)0 : sQLData.getShort();
            this.testDataTruncation(n, sQLData, true);
            return s;
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            String string = sQLData == null ? null : sQLData.getString();
            this.testDataTruncation(n, sQLData, false);
            return string;
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return this.internalGetTime(n, null);
    }

    public Time getTime(String string) throws SQLException {
        return this.internalGetTime(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time internalGetTime(int n, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Time time = sQLData == null ? null : sQLData.getTime(calendar);
            this.testDataTruncation(n, sQLData, false);
            return time;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.internalGetTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.internalGetTimestamp(this.findColumn(string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp internalGetTimestamp(int n, Calendar calendar) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            Timestamp timestamp = sQLData == null ? null : sQLData.getTimestamp(calendar);
            this.testDataTruncation(n, sQLData, false);
            return timestamp;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException("HY024");
        }
        return this.internalGetTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            InputStream inputStream;
            SQLData sQLData = this.getValue(n);
            this.openInputStream_ = inputStream = sQLData == null ? null : sQLData.getUnicodeStream();
            this.testDataTruncation(n, sQLData, false);
            return inputStream;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    private SQLData getValue(int n) throws SQLException {
        this.checkOpen();
        this.clearCurrentValue();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (n < 1) {
            JDError.throwSQLException("07009", n + "<1");
        }
        if (n > this.columnCount_) {
            JDError.throwSQLException("07009", n + ">" + this.columnCount_);
        }
        if (this.concurrency_ == 1008 && (this.updateSet_[n - 1] || this.positionInsert_)) {
            this.wasNull_ = this.updateNulls_[n - 1];
            this.wasDataMappingError_ = false;
            if (this.wasNull_) {
                return null;
            }
            return this.updateRow_.getSQLData(n);
        }
        this.wasNull_ = this.row_.isNull(n);
        this.wasDataMappingError_ = this.row_.isDataMappingError(n);
        SQLData sQLData = this.row_.getSQLType(n);
        int n2 = sQLData.getSQLType();
        if ((n2 == 8 || n2 == 4 || n2 == 12 || n2 == 34 || n2 == 40) && this.statement_ != null) {
            this.statement_.setAssociatedWithLocators(true);
        }
        if (this.wasNull_ || this.wasDataMappingError_) {
            return null;
        }
        return this.row_.getSQLData(n);
    }

    private void testDataTruncation(int n, SQLData sQLData, boolean bl) throws SQLException {
        int n2;
        if (this.wasDataMappingError_) {
            this.postWarning(new DataTruncation(n, false, true, -1, -1));
        }
        if (sQLData != null && (n2 = sQLData.getTruncated()) > 0) {
            if (this.connection_.getVRM() >= JDUtilities.vrm610 && bl) {
                JDError.throwSQLException((Object)this, "07006", "C#=" + n);
            }
            int n3 = sQLData.getActualSize();
            this.postWarning(new DataTruncation(n, false, true, n3, n3 - n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.wasNull_;
        }
    }

    private void beforeUpdate() throws SQLException {
        this.checkOpen();
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    private void beforeUpdateValue(int n) throws SQLException {
        this.beforeUpdate();
        if (!this.positionValid_ && !this.positionInsert_) {
            JDError.throwSQLException("HY109");
        }
        if (n < 1) {
            JDError.throwSQLException("07009", n + "<1");
        }
        if (n > this.columnCount_) {
            JDError.throwSQLException("07009", n + ">" + this.columnCount_);
        }
    }

    private void checkForValidConversion(int n) throws SQLException {
        SQLData sQLData = this.updateRow_.getSQLType(n);
        int n2 = sQLData.getSQLType();
        if (n2 == 41) {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            for (int i = 0; i < this.columnCount_; ++i) {
                this.updateSet_[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionValid_) {
                JDError.throwSQLException("HY109");
            }
            if (this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Deleting a row.");
            }
            if (this.deleteStatement_ == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DELETE FROM ");
                stringBuffer.append(this.selectTable_);
                stringBuffer.append(" WHERE CURRENT OF \"");
                stringBuffer.append(this.cursorName_);
                stringBuffer.append("\"");
                this.deleteStatement_ = this.connection_.prepareStatement(stringBuffer.toString());
            }
            this.deleteStatement_.execute();
            this.positionValid_ = false;
            this.rowCache_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdate();
            if (!this.positionInsert_) {
                JDError.throwSQLException("24000");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this.selectTable_);
            stringBuffer.append(" (");
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                if (n++ > 0) {
                    stringBuffer.append(",");
                    stringBuffer2.append(",");
                }
                stringBuffer.append("\"");
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                stringBuffer.append("\"");
                stringBuffer2.append("?");
            }
            if (n == 0) {
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(1)));
            }
            stringBuffer.append(") VALUES (");
            if (n == 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append(")");
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Inserting a row: " + stringBuffer);
            }
            PreparedStatement preparedStatement = this.connection_.prepareStatement(stringBuffer.toString());
            int n2 = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                if (!this.updateSet_[i]) continue;
                Object object = this.updateRow_.getSQLData(i + 1).getObject();
                if (this.updateNulls_[i]) {
                    preparedStatement.setNull(++n2, this.row_.getSQLType(i + 1).getType());
                } else if (this.updateDefaults_[i]) {
                    ((AS400JDBCPreparedStatement)preparedStatement).setDB2Default(++n2);
                } else if (this.updateUnassigned_[i]) {
                    ((AS400JDBCPreparedStatement)preparedStatement).setDB2Unassigned(++n2);
                } else {
                    preparedStatement.setObject(++n2, object);
                }
                this.updateSet_[i] = false;
            }
            preparedStatement.executeUpdate();
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null) {
                this.postWarning(sQLWarning);
            }
            preparedStatement.close();
            this.rowCache_.flush();
        }
    }

    private static final String prepareQuotes(String string) {
        return JDUtilities.prepareForDoubleQuotes(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            return !this.positionValid_ && !this.positionInsert_ && (this.positionFromFirst_ > 0 || this.positionFromLast_ > 0);
        }
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    private void testDataTruncation2(int n, SQLData sQLData) throws SQLException {
        if (sQLData != null) {
            this.connection_.testDataTruncation(null, this, n, false, sQLData, null);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + n);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToString(inputStream, n2, "ISO8859_1"), null, -1);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal, null, -1);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, n2), null, -1);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, new Short((short)(bl ? 1 : 0)), null, -1);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateValue(n, blob, null, -1);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateValue(this.findColumn(string), blob, null, -1);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, new Short(by), null, -1);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray, null, -1);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, n2), null, -1);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateValue(n, clob, null, -1);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateValue(this.findColumn(string), clob, null, -1);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date, null, -1);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, new Double(d), null, -1);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, new Float(f), null, -1);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, new Integer(n2), null, -1);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, new Long(l), null, -1);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.updateValue(n, null, null, -1);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateDB2Default(int n) throws SQLException {
        this.updateValueExtendedIndicator(n, 1);
    }

    public void updateDBDefault(int n) throws SQLException {
        this.updateDB2Default(n);
    }

    public void updateDB2Default(String string) throws SQLException {
        this.updateDB2Default(this.findColumn(string));
    }

    public void updateDBDefault(String string) throws SQLException {
        this.updateDB2Default(this.findColumn(string));
    }

    public void updateDB2Unassigned(int n) throws SQLException {
        this.updateValueExtendedIndicator(n, 2);
    }

    public void updateDBUnassigned(int n) throws SQLException {
        this.updateDB2Unassigned(n);
    }

    public void updateDB2Unassigned(String string) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(string));
    }

    public void updateDBUnassigned(String string) throws SQLException {
        this.updateDB2Unassigned(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateValue(n, object, null, -1);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException("HY094");
        }
        this.updateValue(n, object, null, n2);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        JDError.throwSQLException("07006", "C#=" + n);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        this.beforeUpdate();
        ConvTable convTable = null;
        if (this.positionInsert_ || !this.positionValid_) {
            JDError.throwSQLException("24000");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.selectTable_);
        if (this.correlationName_ != null) {
            stringBuffer.append(" AS ");
            stringBuffer.append(this.correlationName_);
        }
        stringBuffer.append(" SET ");
        int n = 0;
        for (int i = 0; i < this.columnCount_; ++i) {
            if (!this.updateSet_[i]) continue;
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\"");
            if (this.statement_ != null) {
                if (this.extendedDescriptors_ != null) {
                    convTable = this.connection_.getConverter();
                    String string = this.extendedDescriptors_.getColumnDescriptors(i + 1, convTable, this.settings_).getBaseColumnName(convTable);
                    if (string != null) {
                        if (this.connection_.getVRM() < JDUtilities.vrm540) {
                            stringBuffer.append(JDUtilities.stripOuterDoubleQuotes(string));
                        } else {
                            stringBuffer.append(AS400JDBCResultSet.prepareQuotes(string));
                        }
                    } else {
                        stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                    }
                } else {
                    stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
                }
            } else {
                stringBuffer.append(AS400JDBCResultSet.prepareQuotes(this.row_.getFieldName(i + 1)));
            }
            stringBuffer.append("\"=?");
        }
        stringBuffer.append(" WHERE CURRENT OF \"");
        stringBuffer.append(this.cursorName_);
        stringBuffer.append("\"");
        if (n > 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Updating a row: " + stringBuffer);
            }
            PreparedStatement preparedStatement = this.connection_.prepareStatement(stringBuffer.toString());
            try {
                int n2 = 0;
                for (int i = 0; i < this.columnCount_; ++i) {
                    if (!this.updateSet_[i]) continue;
                    Object object = this.updateRow_.getSQLData(i + 1).getObject();
                    if (this.updateNulls_[i]) {
                        preparedStatement.setNull(++n2, this.row_.getSQLType(i + 1).getType());
                        continue;
                    }
                    if (this.updateDefaults_[i]) {
                        ((AS400JDBCPreparedStatement)preparedStatement).setDB2Default(++n2);
                        continue;
                    }
                    if (this.updateUnassigned_[i]) {
                        ((AS400JDBCPreparedStatement)preparedStatement).setDB2Unassigned(++n2);
                        continue;
                    }
                    preparedStatement.setObject(++n2, object);
                }
                preparedStatement.executeUpdate();
                SQLWarning sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this.postWarning(sQLWarning);
                }
            }
            finally {
                preparedStatement.close();
            }
            this.rowCache_.flush();
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, new Short(s), null, -1);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string, null, -1);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, time, null, -1);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, timestamp, null, -1);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(int n, Object object, Calendar calendar, int n2) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdateValue(n);
            SQLData sQLData = this.updateRow_.getSQLType(n);
            int n3 = n - 1;
            int n4 = sQLData.getSQLType();
            if (object != null && (n4 == 8 || n4 == 4 || n4 == 12 || n4 == 34 || n4 == 40)) {
                if (object instanceof AS400JDBCBlobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(((AS400JDBCBlobLocator)object).getHandle());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (object instanceof AS400JDBCClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(((AS400JDBCClobLocator)object).getHandle());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (object instanceof AS400JDBCNClobLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(((AS400JDBCNClobLocator)object).getHandle());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (object instanceof AS400JDBCSQLXMLLocator) {
                    try {
                        this.statement_.setAssociatedWithLocators(true);
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(((AS400JDBCSQLXMLLocator)object).getHandle());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (object != null) {
                sQLData.set(object, calendar, n2);
            }
            this.updateNulls_[n3] = object == null;
            this.updateDefaults_[n3] = false;
            this.updateUnassigned_[n3] = false;
            this.updateSet_[n3] = true;
            if (this.dataTruncation_) {
                this.testDataTruncation2(n, sQLData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHoldability() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.statement_ != null) {
                JDCursor jDCursor;
                int n = 0;
                if (this.connection_ != null) {
                    n = this.connection_.getVRM();
                }
                if ((jDCursor = this.statement_.getCursor()).getCursorAttributeHoldable() == 0 && (n <= JDUtilities.vrm610 || n >= JDUtilities.vrm710 && jDCursor.getCursorIsolationLevel() != 0)) {
                    return 2;
                }
                if (jDCursor.getCursorAttributeHoldable() == 1 || n >= JDUtilities.vrm710 && jDCursor.getCursorIsolationLevel() == 0) {
                    return 1;
                }
                int n2 = this.statement_.getInternalResultSetHoldability();
                if (n2 == 1 || n2 == 2) {
                    return n2;
                }
            }
            if (this.connection_ instanceof AS400JDBCConnection && this.connection_ != null) {
                return this.connection_.getHoldability();
            }
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getNCharacterStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            Reader reader;
            SQLData sQLData = this.getValue(n);
            this.openReader_ = reader = sQLData == null ? null : sQLData.getNCharacterStream();
            this.testDataTruncation(n, sQLData, false);
            return reader;
        }
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNString(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            SQLData sQLData = this.getValue(n);
            String string = sQLData == null ? null : sQLData.getNString();
            this.testDataTruncation(n, sQLData, false);
            return string;
        }
    }

    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    public void updateNString(int n, String string) throws SQLException {
        this.updateValue(n, string, null, -1);
    }

    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCResultSet", "java.sql.ResultSet"};
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToString(inputStream, (int)l, "ISO8859_1"), null, -1);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, (int)l), null, -1);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream, (int)l), null, -1);
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, (int)l), null, -1);
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, (int)l), null, -1);
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, (int)l), null, -1);
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (l < 0L) {
            JDError.throwSQLException("HY090");
        }
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader, (int)l), null, -1);
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream), null, -1);
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream), null, -1);
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateValue(n, inputStream == null ? null : JDUtilities.streamToBytes(inputStream), null, -1);
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        this.beforeUpdateValue(n);
        this.checkForValidConversion(n);
        this.updateValue(n, reader == null ? null : JDUtilities.readerToString(reader), null, -1);
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(string), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueExtendedIndicator(int n, int n2) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.beforeUpdateValue(n);
            int n3 = n - 1;
            this.updateNulls_[n3] = false;
            this.updateDefaults_[n3] = n2 == 1;
            this.updateUnassigned_[n3] = n2 == 2;
            this.updateSet_[n3] = true;
        }
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if (clazz == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byArray = new byte[1];
            this.byteArrayClass_ = byArray.getClass();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AS400JDBCResultSet.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getString(n);
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = AS400JDBCResultSet.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            byte by = this.getByte(n);
            if (by == 0 && this.wasNull()) {
                return null;
            }
            return new Byte(by);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = AS400JDBCResultSet.class$("java.lang.Short")) : class$java$lang$Short)) {
            short s = this.getShort(n);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = AS400JDBCResultSet.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            int n2 = this.getInt(n);
            if (n2 == 0 && this.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = AS400JDBCResultSet.class$("java.lang.Long")) : class$java$lang$Long)) {
            long l = this.getLong(n);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = AS400JDBCResultSet.class$("java.lang.Float")) : class$java$lang$Float)) {
            float f = this.getFloat(n);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = AS400JDBCResultSet.class$("java.lang.Double")) : class$java$lang$Double)) {
            double d = this.getDouble(n);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400JDBCResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return this.getBigDecimal(n);
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AS400JDBCResultSet.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            boolean bl = this.getBoolean(n);
            if (!bl && this.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }
        if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = AS400JDBCResultSet.class$("java.sql.Date")) : class$java$sql$Date)) {
            return this.getDate(n);
        }
        if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = AS400JDBCResultSet.class$("java.sql.Time")) : class$java$sql$Time)) {
            return this.getTime(n);
        }
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = AS400JDBCResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return this.getTimestamp(n);
        }
        if (clazz == this.byteArrayClass_) {
            return this.getBytes(n);
        }
        if (clazz == (class$java$io$InputStream == null ? (class$java$io$InputStream = AS400JDBCResultSet.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            return this.getBinaryStream(n);
        }
        if (clazz == (class$java$io$Reader == null ? (class$java$io$Reader = AS400JDBCResultSet.class$("java.io.Reader")) : class$java$io$Reader)) {
            return this.getCharacterStream(n);
        }
        if (clazz == (class$java$sql$Clob == null ? (class$java$sql$Clob = AS400JDBCResultSet.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return this.getClob(n);
        }
        if (clazz == (class$java$sql$Array == null ? (class$java$sql$Array = AS400JDBCResultSet.class$("java.sql.Array")) : class$java$sql$Array)) {
            return this.getArray(n);
        }
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = AS400JDBCResultSet.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return this.getBlob(n);
        }
        if (clazz == (class$java$sql$Ref == null ? (class$java$sql$Ref = AS400JDBCResultSet.class$("java.sql.Ref")) : class$java$sql$Ref)) {
            return this.getRef(n);
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AS400JDBCResultSet.class$("java.net.URL")) : class$java$net$URL)) {
            return this.getURL(n);
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AS400JDBCResultSet.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getObject(n);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    protected void addSavedException(SQLException sQLException) {
        this.savedException_ = sQLException;
    }

    static int getDBSQLRequestDSCursorType(String string, int n, int n2) {
        switch (n) {
            case 1003: {
                if (string.equalsIgnoreCase("insensitive") && n2 == 1007) {
                    return 5;
                }
                if (string.equalsIgnoreCase("sensitive")) {
                    return 4;
                }
                return 0;
            }
            case 1005: {
                if (string.equalsIgnoreCase("sensitive")) {
                    return 3;
                }
                if (string.equalsIgnoreCase("asensitive")) {
                    return 1;
                }
                return 3;
            }
        }
        return 2;
    }

    int mapSQLType(Object object) throws SQLException {
        return 0;
    }

    public void updateObject(int n, Object object, Object object2, int n2) throws SQLException {
        this.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object, Object object2, int n) throws SQLException {
        this.updateObject(string, object, n);
    }

    public void updateObject(int n, Object object, Object object2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object, Object object2) throws SQLException {
        this.updateObject(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

