/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDataSource;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCRowSetEventSupport;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class AS400JDBCRowSet
implements RowSet,
Serializable {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final String className_ = "AS400JDBCRowSet";
    private String command_;
    private String dataSourceName_;
    private boolean useDataSource_ = true;
    private String url_;
    private String username_;
    private char[] confusedPasswordChars_;
    private Connection connection_;
    private DataSource dataSource_;
    private AS400JDBCPreparedStatement statement_;
    private transient AS400JDBCResultSet resultSet_;
    private transient AS400JDBCRowSetEventSupport eventSupport_;
    private Context context_ = null;
    private Hashtable environment_ = null;
    private boolean isReadOnly_ = false;
    private int transactionIsolation_ = 1;
    private Map typeMap_;
    private boolean createNewStatement_ = true;
    private int concurrency_ = 1007;
    private boolean escapeProcessing_ = true;
    private int type_ = 1003;
    private transient PropertyChangeSupport changes_;

    public AS400JDBCRowSet() {
        this.initializeTransient();
    }

    public AS400JDBCRowSet(String string) {
        this();
        this.setDataSourceName(string);
    }

    public AS400JDBCRowSet(String string, String string2, String string3) {
        this();
        this.setUrl(string);
        this.setUsername(string2);
        this.setPassword(string3);
    }

    public AS400JDBCRowSet(String string, String string2, char[] cArray) {
        this();
        this.setUrl(string);
        this.setUsername(string2);
        this.setPassword(cArray);
    }

    public boolean absolute(int n) throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.absolute(n);
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.eventSupport_.addRowSetListener(rowSetListener);
    }

    public void afterLast() throws SQLException {
        this.validateResultSet();
        this.resultSet_.afterLast();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void beforeFirst() throws SQLException {
        this.validateResultSet();
        this.resultSet_.beforeFirst();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void cancelRowUpdates() throws SQLException {
        this.validateResultSet();
        this.resultSet_.cancelRowUpdates();
    }

    public void clearParameters() throws SQLException {
        if (this.statement_ != null) {
            this.statement_.clearParameters();
        }
    }

    public void clearWarnings() throws SQLException {
        this.validateResultSet();
        this.resultSet_.clearWarnings();
    }

    public void close() throws SQLException {
        block8: {
            block7: {
                try {
                    if (this.resultSet_ != null) {
                        this.resultSet_.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!JDTrace.isTraceOn()) break block7;
                    JDTrace.logInformation(this, "Closing result set while closing the row set failed: " + sQLException.getMessage());
                }
            }
            try {
                if (this.statement_ != null) {
                    this.statement_.close();
                }
            }
            catch (SQLException sQLException) {
                if (!JDTrace.isTraceOn()) break block8;
                JDTrace.logInformation(this, "Closing statement set while closing the row set failed: " + sQLException.getMessage());
            }
        }
        if (this.connection_ != null) {
            this.connection_.close();
        }
    }

    private void connect() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "connect()");
        }
        if (this.isUseDataSource()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "using JDBC DataSource");
            }
            if (this.dataSourceName_ == null) {
                throw new ExtendedIllegalStateException("dataSourceName", 4);
            }
            try {
                if (this.context_ == null) {
                    this.context_ = this.environment_ == null ? new InitialContext() : new InitialContext(this.environment_);
                }
                this.dataSource_ = (DataSource)this.context_.lookup(this.dataSourceName_);
            }
            catch (NamingException namingException) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(this, "Cannot find JNDI data source.", namingException);
                }
                ExtendedIllegalStateException extendedIllegalStateException = new ExtendedIllegalStateException("dataSourceName", 13);
                extendedIllegalStateException.initCause(namingException);
                throw extendedIllegalStateException;
            }
            this.connection_ = this.dataSource_ instanceof AS400JDBCDataSource ? ((AS400JDBCDataSource)this.dataSource_).getConnection(this.username_, AS400JDBCDataSource.xpwDeconfuseToChar(this.confusedPasswordChars_)) : this.dataSource_.getConnection(this.username_, new String(AS400JDBCDataSource.xpwDeconfuseToChar(this.confusedPasswordChars_)));
        } else {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "using JDBC url");
            }
            if (this.url_ == null) {
                throw new ExtendedIllegalStateException("url", 4);
            }
            this.connection_ = this.username_ != null && this.confusedPasswordChars_ != null ? DriverManager.getConnection(this.url_, this.username_, new String(AS400JDBCDataSource.xpwDeconfuseToChar(this.confusedPasswordChars_))) : DriverManager.getConnection(this.url_);
        }
        this.connection_.setReadOnly(this.isReadOnly_);
        if (this.transactionIsolation_ != 1) {
            this.connection_.setTransactionIsolation(this.transactionIsolation_);
        }
    }

    private void createStatement() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "createStatement()");
        }
        if (this.command_ == null) {
            throw new ExtendedIllegalStateException("command", 4);
        }
        if (this.connection_ == null) {
            this.connect();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if (this.statement_ != null) {
            n = this.statement_.getFetchDirection();
            n2 = this.statement_.getFetchSize();
            n3 = this.statement_.getMaxFieldSize();
            n4 = this.statement_.getMaxRows();
            n5 = this.statement_.getQueryTimeout();
            bl = true;
        }
        this.statement_ = (AS400JDBCPreparedStatement)this.connection_.prepareStatement(this.command_, this.type_, this.concurrency_);
        if (bl) {
            this.statement_.setFetchDirection(n);
            this.statement_.setFetchSize(n2);
            this.statement_.setMaxFieldSize(n3);
            this.statement_.setMaxRows(n4);
            this.statement_.setQueryTimeout(n5);
        }
        this.createNewStatement_ = false;
    }

    public void deleteRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.deleteRow();
    }

    public void execute() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "execute()");
        }
        if (this.createNewStatement_) {
            this.createStatement();
        }
        if (this.command_.toUpperCase().indexOf("SELECT") != -1) {
            this.resultSet_ = (AS400JDBCResultSet)this.statement_.executeQuery();
            this.eventSupport_.fireRowSetChanged(new RowSetEvent(this));
        } else {
            this.statement_.executeUpdate();
        }
    }

    protected void finalize() throws SQLException {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            JDError.throwSQLException("HY001");
        }
    }

    public int findColumn(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.findColumn(string);
    }

    public boolean first() throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.first();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    public Array getArray(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getArray(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getAsciiStream(string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBigDecimal(string, n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBinaryStream(string);
    }

    public Blob getBlob(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBlob(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBoolean(string);
    }

    public byte getByte(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getByte(string);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getBytes(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCharacterStream(string);
    }

    public Clob getClob(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getClob(string);
    }

    public String getCommand() {
        return this.command_;
    }

    public int getConcurrency() throws SQLException {
        if (this.resultSet_ != null) {
            this.concurrency_ = this.resultSet_.getConcurrency();
        }
        return this.concurrency_;
    }

    public Context getContext() {
        return this.context_;
    }

    public String getCursorName() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getCursorName();
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public Date getDate(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(n);
    }

    public Date getDate(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(string);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDate(string, calendar);
    }

    public double getDouble(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getDouble(string);
    }

    public Hashtable getEnvironment() {
        return this.environment_;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing_;
    }

    public int getFetchDirection() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getFetchDirection();
        }
        if (this.statement_ == null) {
            return 1000;
        }
        return this.statement_.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getFetchSize();
        }
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getFetchSize();
    }

    public float getFloat(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getFloat(string);
    }

    public int getInt(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getLong(string);
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        if (this.statement_ == null) {
            return 0;
        }
        return this.statement_.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(string);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(n, map);
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(string, map);
    }

    public String getPassword() {
        return "";
    }

    public int getQueryTimeout() throws SQLException {
        this.validateStatement();
        return this.statement_.getQueryTimeout();
    }

    public Ref getRef(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRef(string);
    }

    public int getRow() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getRow();
    }

    public short getShort(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getShort(n);
    }

    public short getShort(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getStatement();
    }

    public String getString(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getString(n);
    }

    public String getString(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getString(string);
    }

    public Time getTime(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(n);
    }

    public Time getTime(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(string);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(string);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getTimestamp(string, calendar);
    }

    public int getTransactionIsolation() {
        try {
            if (this.connection_ != null) {
                return this.connection_.getTransactionIsolation();
            }
            return this.transactionIsolation_;
        }
        catch (SQLException sQLException) {
            JDTrace.logInformation(this, "getTransactionIsolation() database error");
            return this.transactionIsolation_;
        }
    }

    public int getType() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getType();
        }
        return this.type_;
    }

    public Map getTypeMap() throws SQLException {
        if (this.connection_ != null) {
            return this.connection_.getTypeMap();
        }
        return this.typeMap_;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getUnicodeStream(string);
    }

    public String getUrl() {
        return this.url_;
    }

    public URL getURL(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getURL(string);
    }

    public String getUsername() {
        return this.username_;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getWarnings();
    }

    private void initializeTransient() {
        this.eventSupport_ = new AS400JDBCRowSetEventSupport();
        this.changes_ = new PropertyChangeSupport(this);
        this.resultSet_ = null;
    }

    public void insertRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.isLast();
    }

    public boolean isReadOnly() {
        if (this.connection_ != null) {
            try {
                return this.connection_.isReadOnly();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.isReadOnly_;
    }

    public boolean isUseDataSource() {
        return this.useDataSource_;
    }

    public boolean last() throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.last();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.moveToCurrentRow();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public void moveToInsertRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.moveToInsertRow();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
    }

    public boolean next() throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.next();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    public boolean previous() throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.previous();
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        this.validateResultSet();
        boolean bl = this.resultSet_.relative(n);
        this.eventSupport_.fireCursorMoved(new RowSetEvent(this));
        return bl;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.eventSupport_.removeRowSetListener(rowSetListener);
    }

    public boolean rowDeleted() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.rowUpdated();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.validateStatement();
        this.statement_.setArray(n, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(n, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validateStatement();
        this.statement_.setBigDecimal(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(n, inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(n, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.validateStatement();
        this.statement_.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.validateStatement();
        this.statement_.setByte(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.validateStatement();
        this.statement_.setBytes(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(n, reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(n, clob);
    }

    public void setCommand(String string) throws SQLException {
        String string2 = "command";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.command_;
        this.command_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setCommand", string2, string);
        }
    }

    public void setConcurrency(int n) {
        String string = "concurrency";
        switch (n) {
            case 1007: {
                break;
            }
            case 1008: {
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(string, 4);
            }
        }
        Integer n2 = new Integer(this.concurrency_);
        Integer n3 = new Integer(n);
        this.concurrency_ = n;
        this.changes_.firePropertyChange(string, n2, n3);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setConcurrency", "concurrency", n);
        }
    }

    public void setContext(Context context) {
        String string = "context";
        if (context == null) {
            throw new NullPointerException(string);
        }
        Context context2 = this.getContext();
        Context context3 = context;
        this.context_ = context;
        this.changes_.firePropertyChange(string, context2, context3);
    }

    public void setDataSourceName(String string) {
        String string2 = "dataSourceName";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getDataSourceName();
        this.dataSourceName_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(n, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(n, date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.validateStatement();
        this.statement_.setDouble(n, d);
    }

    public void setEnvironment(Hashtable hashtable) {
        String string = "enviroment";
        if (hashtable == null) {
            throw new NullPointerException(string);
        }
        Hashtable hashtable2 = this.getEnvironment();
        Hashtable hashtable3 = hashtable;
        this.environment_ = hashtable;
        this.changes_.firePropertyChange(string, hashtable2, hashtable3);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        Boolean bl2 = new Boolean(this.getEscapeProcessing());
        this.validateStatement();
        this.statement_.setEscapeProcessing(bl);
        this.escapeProcessing_ = bl;
        this.changes_.firePropertyChange("escapeProcessing", bl2, new Boolean(bl));
    }

    public void setFetchDirection(int n) throws SQLException {
        Integer n2 = new Integer(this.getFetchDirection());
        if (this.resultSet_ != null) {
            this.resultSet_.setFetchDirection(n);
        }
        this.validateStatement();
        this.statement_.setFetchDirection(n);
        this.changes_.firePropertyChange("fetchDirection", n2, new Integer(n));
    }

    public void setFetchSize(int n) throws SQLException {
        Integer n2 = new Integer(this.getFetchSize());
        if (this.resultSet_ != null) {
            this.resultSet_.setFetchSize(n);
        }
        this.validateStatement();
        this.statement_.setFetchSize(n);
        this.changes_.firePropertyChange("fetchSize", n2, new Integer(n));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.validateStatement();
        this.statement_.setFloat(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setLong(n, l);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        String string = "maxFieldSize";
        this.validateStatement();
        Integer n2 = new Integer(this.getMaxFieldSize());
        Integer n3 = new Integer(n);
        this.statement_.setMaxFieldSize(n);
        this.changes_.firePropertyChange(string, n2, n3);
    }

    public void setMaxRows(int n) throws SQLException {
        String string = "maxRows";
        this.validateStatement();
        Integer n2 = new Integer(this.getMaxRows());
        Integer n3 = new Integer(n);
        this.statement_.setMaxRows(n);
        this.changes_.firePropertyChange(string, n2, n3);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(n, n2, string);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(n, object, n2, n3);
    }

    public void setPassword(String string) {
        String string2 = "password";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateConnection();
        this.confusedPasswordChars_ = AS400JDBCDataSource.xpwConfuse(string);
        this.changes_.firePropertyChange(string2, "", string);
    }

    public void setPassword(char[] cArray) {
        String string = "password";
        if (cArray == null) {
            throw new NullPointerException(string);
        }
        this.validateConnection();
        this.confusedPasswordChars_ = AS400JDBCDataSource.xpwConfuse(cArray);
        this.changes_.firePropertyChange(string, "", cArray);
    }

    public void setQueryTimeout(int n) throws SQLException {
        String string = "timeout";
        this.validateStatement();
        Integer n2 = new Integer(this.getQueryTimeout());
        Integer n3 = new Integer(n);
        this.statement_.setQueryTimeout(n);
        this.changes_.firePropertyChange(string, n2, n3);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        String string = "readOnly";
        Boolean bl2 = new Boolean(this.isReadOnly());
        Boolean bl3 = new Boolean(bl);
        if (this.connection_ != null) {
            this.connection_.setReadOnly(bl);
        }
        this.isReadOnly_ = bl;
        this.changes_.firePropertyChange(string, bl2, bl3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.validateStatement();
        this.statement_.setRef(n, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.validateStatement();
        this.statement_.setShort(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this.validateStatement();
        this.statement_.setString(n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(n, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(n, timestamp, calendar);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        String string = "transactionIsolation";
        Integer n2 = new Integer(this.getTransactionIsolation());
        Integer n3 = new Integer(n);
        if (this.connection_ != null) {
            this.connection_.setTransactionIsolation(n);
        }
        this.transactionIsolation_ = n;
        this.changes_.firePropertyChange(string, n2, n3);
    }

    public void setType(int n) throws SQLException {
        String string = "type";
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(string, 4);
            }
        }
        Integer n2 = new Integer(this.getType());
        Integer n3 = new Integer(this.type_);
        this.type_ = n;
        this.changes_.firePropertyChange(string, n2, n3);
        this.createNewStatement_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setType", string, n);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (this.connection_ != null) {
            this.connection_.setTypeMap(map);
        }
        this.typeMap_ = map;
    }

    public void setUrl(String string) {
        String string2 = "url";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateConnection();
        String string3 = this.getUrl();
        this.url_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
        this.useDataSource_ = false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setUrl", string2, string);
        }
    }

    public void setUseDataSource(boolean bl) {
        String string = "useDataSource";
        this.validateConnection();
        Boolean bl2 = new Boolean(this.isUseDataSource());
        this.useDataSource_ = bl;
        this.changes_.firePropertyChange(string, bl2, new Boolean(bl));
    }

    public void setUsername(String string) {
        String string2 = "username";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateConnection();
        String string3 = this.getUsername();
        this.username_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
    }

    public String toString() {
        if (this.resultSet_ != null) {
            return this.resultSet_.toString();
        }
        return "";
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateArray(n, array);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateArray(string, array);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(n, inputStream, n2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(string, inputStream, n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBigDecimal(n, bigDecimal);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBigDecimal(string, bigDecimal);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(n, inputStream, n2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(string, inputStream, n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(n, blob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(string, blob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBoolean(n, bl);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBoolean(string, bl);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateByte(n, by);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateByte(string, by);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBytes(n, byArray);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBytes(string, byArray);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(n, reader, n2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(string, reader, n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(n, clob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(string, clob);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDate(n, date);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDate(string, date);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDouble(n, d);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateDouble(string, d);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateFloat(n, f);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateFloat(string, f);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateInt(n, n2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateInt(string, n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateLong(n, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateLong(string, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNull(int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNull(n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNull(String string) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNull(string);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(n, object);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(string, object);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(n, object, n2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateObject(string, object, n);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRow() throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRow();
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRef(n, ref);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateRef(string, ref);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateShort(n, s);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateShort(string, s);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateString(int n, String string) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateString(n, string);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateString(String string, String string2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateString(string, string2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTime(n, time);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTime(string, time);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTimestamp(n, timestamp);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateTimestamp(string, timestamp);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    private void validateConnection() {
        if (this.connection_ != null) {
            throw new ExtendedIllegalStateException("connection", 5);
        }
    }

    private void validateResultSet() {
        if (this.resultSet_ == null) {
            throw new ExtendedIllegalStateException("resultSet", 3);
        }
    }

    private void validateStatement() throws SQLException {
        if (this.statement_ == null) {
            this.createStatement();
        }
    }

    public boolean wasNull() throws SQLException {
        this.validateResultSet();
        return this.resultSet_.wasNull();
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(n, reader, l);
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(this.statement_.findParameterIndex(string), reader, l);
    }

    public void setNString(int n, String string) throws SQLException {
        this.validateStatement();
        this.statement_.setNString(n, string);
    }

    public void setNString(String string, String string2) throws SQLException {
        this.validateStatement();
        this.statement_.setNString(this.statement_.findParameterIndex(string), string2);
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNCharacterStream(n);
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNCharacterStream(string);
    }

    public String getNString(int n) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNString(n);
    }

    public String getNString(String string) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getNString(string);
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet_.isClosed();
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(n, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(string, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(n, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(string, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(n, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(string, inputStream, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(n, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(string, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(n, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(string, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(n, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(string, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(n, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(string, reader, l);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNString(int n, String string) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNString(n, string);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNString(String string, String string2) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNString(string, string2);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCRowSet", "javax.sql.RowSet"};
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(n, inputStream);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(this.statement_.findParameterIndex(string), inputStream, n);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setAsciiStream(this.statement_.findParameterIndex(string), inputStream);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.validateStatement();
        this.statement_.setBigDecimal(this.statement_.findParameterIndex(string), bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(n, inputStream);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(this.statement_.findParameterIndex(string), inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBinaryStream(this.statement_.findParameterIndex(string), inputStream);
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(n, inputStream, l);
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(n, inputStream);
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(string), blob);
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(string), inputStream, l);
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.validateStatement();
        this.statement_.setBlob(this.statement_.findParameterIndex(string), inputStream);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.validateStatement();
        this.statement_.setBoolean(this.statement_.findParameterIndex(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.validateStatement();
        this.statement_.setByte(this.statement_.findParameterIndex(string), by);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.validateStatement();
        this.statement_.setBytes(this.statement_.findParameterIndex(string), byArray);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(n, reader);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(this.statement_.findParameterIndex(string), reader, n);
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setCharacterStream(this.statement_.findParameterIndex(string), reader);
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(n, reader, l);
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(n, reader);
    }

    public void setClob(String string, Clob clob) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(string), clob);
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(string), reader, l);
    }

    public void setClob(String string, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setClob(this.statement_.findParameterIndex(string), reader);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(this.statement_.findParameterIndex(string), date, calendar);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.validateStatement();
        this.statement_.setDate(this.statement_.findParameterIndex(string), date);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.validateStatement();
        this.statement_.setDouble(this.statement_.findParameterIndex(string), d);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.validateStatement();
        this.statement_.setFloat(this.statement_.findParameterIndex(string), f);
    }

    public void setInt(String string, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setInt(this.statement_.findParameterIndex(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setLong(this.statement_.findParameterIndex(string), l);
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(n, reader);
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNCharacterStream(this.statement_.findParameterIndex(string), reader);
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(n, reader, l);
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(n, reader);
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(this.statement_.findParameterIndex(string), reader, l);
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        this.validateStatement();
        this.statement_.setNClob(this.statement_.findParameterIndex(string), reader);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(this.statement_.findParameterIndex(string), n, string2);
    }

    public void setNull(String string, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setNull(this.statement_.findParameterIndex(string), n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(string), object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(string), object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.validateStatement();
        this.statement_.setObject(this.statement_.findParameterIndex(string), object);
    }

    public void setShort(String string, short s) throws SQLException {
        this.validateStatement();
        this.statement_.setShort(this.statement_.findParameterIndex(string), s);
    }

    public void setString(String string, String string2) throws SQLException {
        this.validateStatement();
        this.statement_.setString(this.statement_.findParameterIndex(string), string2);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(this.statement_.findParameterIndex(string), time, calendar);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.validateStatement();
        this.statement_.setTime(this.statement_.findParameterIndex(string), time);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(this.statement_.findParameterIndex(string), timestamp, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.validateStatement();
        this.statement_.setTimestamp(this.statement_.findParameterIndex(string), timestamp);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.validateStatement();
        this.statement_.setURL(n, uRL);
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(n, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateAsciiStream(string, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(n, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBinaryStream(string, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(n, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateBlob(string, inputStream);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(n, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateCharacterStream(string, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(n, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateClob(string, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(n, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNCharacterStream(string, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(n, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        this.validateResultSet();
        this.resultSet_.updateNClob(string, reader);
        this.eventSupport_.fireRowChanged(new RowSetEvent(this));
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(n, clazz);
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        this.validateResultSet();
        return this.resultSet_.getObject(string, clazz);
    }
}

