/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400PackedDecimal
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits_;
    private int scale_;
    private static final long defaultValue = 0L;
    static final boolean HIGH_NIBBLE = true;
    static final boolean LOW_NIBBLE = false;
    private boolean useDouble_ = false;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public AS400PackedDecimal(int n, int n2) {
        if (n < 1 || n > 63) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(n) + ")", 4);
        }
        if (n2 < 0 || n2 > n) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(n2) + ")", 4);
        }
        this.digits_ = n;
        this.scale_ = n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        return this.digits_ / 2 + 1;
    }

    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    public int getInstanceType() {
        return 7;
    }

    public Class getJavaType() {
        return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400PackedDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    }

    public int getNumberOfDigits() {
        return this.digits_;
    }

    public int getNumberOfDecimalPositions() {
        return this.scale_;
    }

    public boolean isUseDouble() {
        return this.useDouble_;
    }

    public void setUseDouble(boolean bl) {
        this.useDouble_ = bl;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.digits_ / 2 + 1];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        int n2;
        int n3 = this.digits_;
        int n4 = this.scale_;
        int n5 = n3 / 2 + 1;
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = (BigDecimal)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "ClassCastException when attempting to cast a " + object.getClass().getName() + " to a BigDecimal", (Throwable)classCastException);
            throw classCastException;
        }
        if (bigDecimal.scale() > n4) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        int n6 = bigDecimal.signum();
        char[] cArray = bigDecimal.abs().movePointRight(n4).toBigInteger().toString().toCharArray();
        int n7 = cArray.length;
        if (n7 > n3) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        int n8 = 0;
        int n9 = n3 % 2 == 0 ? n3 - n7 + 1 : n3 - n7;
        for (n2 = 0; n2 < n9 - 1; n2 += 2) {
            byArray[n++] = 0;
        }
        if (n9 > 0) {
            if (n9 % 2 != 0) {
                byArray[n++] = (byte)(cArray[n8++] & 0xF);
            }
        } else if (Trace.traceOn_) {
            Trace.log(1, "The calculated number of leading zeros is negative.", n9);
        }
        while (n8 < cArray.length - 1) {
            n2 = (cArray[n8++] & 0xF) << 4;
            int n10 = cArray[n8++] & 0xF;
            byArray[n++] = (byte)(n2 + n10);
        }
        n2 = (cArray[n8++] & 0xF) << 4;
        byArray[n++] = n6 != -1 ? (byte)(n2 + 15) : (byte)(n2 + 13);
        return n5;
    }

    public byte[] toBytes(double d) {
        byte[] byArray = new byte[this.digits_ / 2 + 1];
        this.toBytes(d, byArray, 0);
        return byArray;
    }

    public int toBytes(double d, byte[] byArray) {
        return this.toBytes(d, byArray, 0);
    }

    public int toBytes(double d, byte[] byArray, int n) {
        int n2;
        int n3;
        double d2 = Math.abs(d);
        if (d2 > 9.223372036854776E18) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        long l = (long)d2;
        int n4 = this.scale_ > 15 ? 15 : this.scale_;
        long l2 = Math.round((d2 - (double)l) * Math.pow(10.0, n4));
        int n5 = this.digits_ / 2;
        int n6 = n + n5;
        boolean bl = true;
        int n7 = this.scale_ - n4;
        for (n3 = 1; n3 <= n7; ++n3) {
            if (bl) {
                int n8 = n6--;
                byArray[n8] = (byte)(byArray[n8] & 0xF);
            } else {
                int n9 = n6;
                byArray[n9] = (byte)(byArray[n9] & 0xFFFFFFF0);
            }
            bl = !bl;
        }
        for (n2 = 1; n2 <= n4; ++n2) {
            n3 = (int)(l2 % 10L);
            if (bl) {
                int n10 = n6;
                byArray[n10] = (byte)(byArray[n10] & 0xF);
                int n11 = n6--;
                byArray[n11] = (byte)(byArray[n11] | (byte)n3 << 4);
            } else {
                int n12 = n6;
                byArray[n12] = (byte)(byArray[n12] & 0xFFFFFFF0);
                int n13 = n6;
                byArray[n13] = (byte)(byArray[n13] | (byte)n3);
            }
            bl = !bl;
            l2 /= 10L;
        }
        n2 = this.digits_ - this.scale_;
        for (int i = 1; i <= n2; ++i) {
            n3 = (int)(l % 10L);
            if (bl) {
                int n14 = n6;
                byArray[n14] = (byte)(byArray[n14] & 0xF);
                int n15 = n6--;
                byArray[n15] = (byte)(byArray[n15] | (byte)n3 << 4);
            } else {
                int n16 = n6;
                byArray[n16] = (byte)(byArray[n16] & 0xFFFFFFF0);
                int n17 = n6;
                byArray[n17] = (byte)(byArray[n17] | (byte)n3);
            }
            bl = !bl;
            l /= 10L;
        }
        while (n6 >= n) {
            if (bl) {
                int n18 = n6--;
                byArray[n18] = (byte)(byArray[n18] & 0xF);
            } else {
                int n19 = n6;
                byArray[n19] = (byte)(byArray[n19] & 0xFFFFFFF0);
            }
            bl = !bl;
        }
        int n20 = n6 = n + n5;
        byArray[n20] = (byte)(byArray[n20] & 0xFFFFFFF0);
        int n21 = n6;
        byArray[n21] = (byte)(byArray[n21] | (byte)(d >= 0.0 ? 15 : 13));
        if (l > 0L) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        return n5 + 1;
    }

    public double toDouble(byte[] byArray) {
        return this.toDouble(byArray, 0);
    }

    public double toDouble(byte[] byArray, int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        double d = 0.0;
        double d2 = Math.pow(10.0, -this.scale_);
        int n2 = n + this.digits_ / 2;
        boolean bl = true;
        int n3 = n2;
        while (n3 >= n) {
            if (bl) {
                d += (double)((byte)((byArray[n3] & 0xF0) >> 4)) * d2;
                --n3;
            } else {
                d += (double)((byte)(byArray[n3] & 0xF)) * d2;
            }
            d2 *= 10.0;
            bl = !bl;
        }
        switch (byArray[n2] & 0xF) {
            case 11: 
            case 13: {
                d *= -1.0;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                AS400PackedDecimal.throwNumberFormatException(false, n2, byArray[n2] & 0xFF, byArray);
            }
        }
        return d;
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        return this.toObject(byArray, n, false);
    }

    public Object toObject(byte[] byArray, int n, boolean bl) {
        int n2 = n;
        if (this.useDouble_) {
            return new Double(this.toDouble(byArray, n));
        }
        if (n < 0) {
            if (bl) {
                return null;
            }
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.digits_;
        int n4 = n3 / 2 + 1;
        if (n3 % 2 == 0) {
            ++n3;
        }
        char[] cArray = null;
        int n5 = 0;
        int n6 = byArray[n + n4 - 1] & 0xF;
        switch (n6) {
            case 11: 
            case 13: {
                cArray = new char[n3 + 1];
                cArray[n5++] = 45;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                cArray = new char[n3];
                break;
            }
            default: {
                if (bl) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(false, n + n4 - 1, byArray[n + n4 - 1] & 0xFF, byArray);
                return null;
            }
        }
        while (n5 < cArray.length - 1) {
            n6 = (byArray[n] & 0xFF) >>> 4;
            if (n6 > 9) {
                if (bl) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(true, n, byArray[n] & 0xFF, byArray);
            }
            cArray[n5] = (char)(n6 | 0x30);
            ++n5;
            n6 = byArray[n] & 0xF;
            if (n6 > 9) {
                if (Trace.traceOn_) {
                    Trace.log(2, " outputPosition=" + n5 + " outputData.length=" + cArray.length + " numDigits = " + n3 + " this.digits = " + this.digits_ + " offset = " + n + " startOffset = " + n2);
                }
                if (bl) {
                    return null;
                }
                AS400PackedDecimal.throwNumberFormatException(false, n, byArray[n] & 0xFF, byArray);
            }
            ++n;
            cArray[n5] = (char)(n6 | 0x30);
            ++n5;
        }
        n6 = (byArray[n] & 0xFF) >>> 4;
        if (n6 > 9) {
            if (bl) {
                return null;
            }
            AS400PackedDecimal.throwNumberFormatException(true, n, byArray[n] & 0xFF, byArray);
        }
        cArray[n5] = (char)(n6 | 0x30);
        return new BigDecimal(new BigInteger(new String(cArray)), this.scale_);
    }

    static final void throwNumberFormatException(boolean bl, int n, int n2, byte[] byArray) throws NumberFormatException {
        String string = bl ? ResourceBundleLoader.getText("EXC_HIGH_NIBBLE_NOT_VALID", Integer.toString(n), AS400PackedDecimal.byteToString(n2)) : ResourceBundleLoader.getText("EXC_LOW_NIBBLE_NOT_VALID", Integer.toString(n), AS400PackedDecimal.byteToString(n2));
        if (Trace.traceOn_) {
            Trace.log(2, "Byte sequence is not valid for a field of type 'packed decimal':", byArray);
        }
        NumberFormatException numberFormatException = new NumberFormatException(string);
        if (Trace.traceOn_) {
            Trace.log(2, numberFormatException);
        }
        throw numberFormatException;
    }

    private static final String byteToString(int n) {
        int n2 = n >>> 4 & 0xF;
        int n3 = n & 0xF;
        char[] cArray = new char[]{n2 < 10 ? (char)(48 + n2) : (char)(n2 - 10 + 65), n3 < 10 ? (char)(48 + n3) : (char)(n3 - 10 + 65)};
        return new String(cArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

