/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400ZonedDecimal
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits;
    private int scale;
    private static final long defaultValue = 0L;
    private static final boolean HIGH_NIBBLE = true;
    private static final boolean LOW_NIBBLE = false;
    private boolean useDouble_ = false;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public AS400ZonedDecimal(int n, int n2) {
        if (n < 1 || n > 63) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(n) + ")", 4);
        }
        if (n2 < 0 || n2 > n) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(n2) + ")", 4);
        }
        this.digits = n;
        this.scale = n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        return this.digits;
    }

    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    public int getInstanceType() {
        return 12;
    }

    public Class getJavaType() {
        return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400ZonedDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    }

    public int getNumberOfDigits() {
        return this.digits;
    }

    public int getNumberOfDecimalPositions() {
        return this.scale;
    }

    public boolean isUseDouble() {
        return this.useDouble_;
    }

    public void setUseDouble(boolean bl) {
        this.useDouble_ = bl;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.digits];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        int n2 = this.digits;
        int n3 = this.scale;
        BigDecimal bigDecimal = (BigDecimal)object;
        if (bigDecimal.scale() > n3) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        int n4 = bigDecimal.signum();
        char[] cArray = bigDecimal.abs().movePointRight(n3).toBigInteger().toString().toCharArray();
        int n5 = cArray.length;
        if (n5 > n2) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        int n6 = 0;
        for (int i = 0; i < n2 - n5; ++i) {
            byArray[n++] = -16;
        }
        while (n6 < cArray.length - 1) {
            byArray[n++] = (byte)(cArray[n6++] & 0xF | 0xF0);
        }
        byArray[n] = n4 != -1 ? (byte)(cArray[n6] & 0xF | 0xF0) : (byte)(cArray[n6] & 0xF | 0xD0);
        return n2;
    }

    public byte[] toBytes(double d) {
        byte[] byArray = new byte[this.digits];
        this.toBytes(d, byArray, 0);
        return byArray;
    }

    public int toBytes(double d, byte[] byArray) {
        return this.toBytes(d, byArray, 0);
    }

    public int toBytes(double d, byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        double d2 = Math.abs(d);
        if (d2 > 9.223372036854776E18) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        long l = (long)d2;
        int n5 = this.scale > 15 ? 15 : this.scale;
        long l2 = Math.round((d2 - (double)l) * Math.pow(10.0, n5));
        int n6 = n + this.digits - 1;
        int n7 = n6 - (this.scale - n5);
        for (n4 = n6; n4 > n7; --n4) {
            byArray[n4] = -16;
        }
        n4 = n6 - this.scale;
        for (n3 = n7; n3 > n4; --n3) {
            n2 = (int)(l2 % 10L);
            byArray[n3] = (byte)(0xF0 | n2);
            l2 /= 10L;
        }
        for (n3 = n4; n3 >= n; --n3) {
            n2 = (int)(l % 10L);
            byArray[n3] = (byte)(0xF0 | n2);
            l /= 10L;
        }
        if (d < 0.0) {
            byArray[n6] = (byte)(byArray[n6] & 0xDF);
        }
        if (l > 0L) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        return this.digits;
    }

    public double toDouble(byte[] byArray) {
        return this.toDouble(byArray, 0);
    }

    public double toDouble(byte[] byArray, int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n + this.digits - 1;
        double d = 0.0;
        if (this.digits < 19) {
            long l = 0L;
            double d2 = Math.pow(10.0, this.scale);
            for (int i = n; i <= n2; ++i) {
                l = l * 10L + (long)((byte)(byArray[i] & 0xF));
            }
            d = (double)l / d2;
        } else {
            double d3 = Math.pow(10.0, this.scale);
            for (int i = n; i <= n2; ++i) {
                d = d * 10.0 + (double)((byte)(byArray[i] & 0xF));
            }
            d /= d3;
        }
        switch (byArray[n2] & 0xF0) {
            case 176: 
            case 208: {
                d *= -1.0;
                break;
            }
            case 160: 
            case 192: 
            case 224: 
            case 240: {
                break;
            }
            default: {
                AS400ZonedDecimal.throwNumberFormatException(true, n2, byArray[n2] & 0xFF, byArray);
            }
        }
        return d;
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        if (this.useDouble_) {
            return new Double(this.toDouble(byArray, n));
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = this.digits;
        int n3 = 0;
        boolean bl = false;
        char[] cArray = null;
        int n4 = (byArray[n + n2 - 1] & 0xFF) >>> 4;
        switch (n4) {
            case 11: 
            case 13: {
                cArray = new char[n2 + 1];
                cArray[n3++] = 45;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                cArray = new char[n2];
                break;
            }
            default: {
                AS400ZonedDecimal.throwNumberFormatException(true, n + n2 - 1, byArray[n + n2 - 1] & 0xFF, byArray);
                return null;
            }
        }
        while (n3 < cArray.length) {
            if ((n4 = byArray[n++] & 0xF) > 9) {
                if (Trace.traceOn_) {
                    Trace.log(2, " outputPosition=" + n3 + " outputData.length=" + cArray.length + " offset (after increment)= " + n);
                }
                AS400ZonedDecimal.throwNumberFormatException(false, n - 1, byArray[n - 1] & 0xFF, byArray);
            }
            cArray[n3++] = (char)(n4 | 0x30);
        }
        return new BigDecimal(new BigInteger(new String(cArray)), this.scale);
    }

    static final void throwNumberFormatException(boolean bl, int n, int n2, byte[] byArray) throws NumberFormatException {
        String string = bl ? ResourceBundleLoader.getText("EXC_HIGH_NIBBLE_NOT_VALID", Integer.toString(n), AS400ZonedDecimal.byteToString(n2)) : ResourceBundleLoader.getText("EXC_LOW_NIBBLE_NOT_VALID", Integer.toString(n), AS400ZonedDecimal.byteToString(n2));
        if (Trace.traceOn_) {
            Trace.log(2, "Byte sequence is not valid for a field of type 'zoned decimal':", byArray);
        }
        NumberFormatException numberFormatException = new NumberFormatException(string);
        if (Trace.traceOn_) {
            Trace.log(2, numberFormatException);
        }
        throw numberFormatException;
    }

    private static final String byteToString(int n) {
        int n2 = n >>> 4 & 0xF;
        int n3 = n & 0xF;
        char[] cArray = new char[]{n2 < 10 ? (char)(48 + n2) : (char)(n2 - 10 + 65), n3 < 10 ? (char)(48 + n3) : (char)(n3 - 10 + 65)};
        return new String(cArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

