/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTableJavaMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.NLS;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class ConvTable {
    static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final char cic_ = '\uffff';
    static final char ric_ = '\ufffe';
    static final char hbic_ = '\u0000';
    static final char pad_ = '\u0000';
    static final byte sbSubChar_ = 63;
    static final char dbSubChar_ = '\ufefe';
    static final char sbSubUnic_ = '\u001a';
    static final char dbSubUnic_ = '\ufffd';
    static final char euro_ = '\u20ac';
    String encoding_;
    int ccsid_ = -1;
    int bidiStringType_ = 0;
    int clientBidiStringType = 0;
    private static final int LARGEST_CCSID = 62251;
    private static final ConvTable[] ccsidPool_ = new ConvTable[62252];
    private static final ConvTable[] ccsidPool1_ = new ConvTable[62252];
    private static final ConvTable[] ccsidPool2_ = new ConvTable[62252];
    private static final Hashtable converterPool_ = new Hashtable();
    private static final String prefix_ = "com.ibm.as400.access.ConvTable";

    ConvTable(int n) {
        this.ccsid_ = n;
        this.encoding_ = ConversionMaps.ccsidToEncoding(this.ccsid_);
        if (this.encoding_ == null) {
            this.encoding_ = "" + this.ccsid_;
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Constructing conversion table for ccsid/encoding: " + this.ccsid_ + "/" + this.encoding_);
            if (this.ccsid_ == 0) {
                if (this instanceof ConvTableJavaMap) {
                    Trace.log(5, "This table is a wrapper around a Java table.");
                } else {
                    Trace.log(5, "Warning: 0 specified for CCSID when table is not a Java table.");
                }
            }
        }
    }

    public String byteArrayToString(byte[] byArray, int n, int n2, int n3) {
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties(n3));
    }

    abstract String byteArrayToString(byte[] var1, int var2, int var3, BidiConversionProperties var4);

    public String byteArrayToString(byte[] byArray, int n, int n2) {
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties(this.bidiStringType_));
    }

    public char[] byteArrayToCharArray(byte[] byArray, int n, int n2) {
        return this.byteArrayToCharArray(byArray, n, n2, new BidiConversionProperties(this.bidiStringType_));
    }

    public char[] byteArrayToCharArray(byte[] byArray, int n, int n2, int n3) {
        return this.byteArrayToCharArray(byArray, n, n2, new BidiConversionProperties(n3));
    }

    abstract char[] byteArrayToCharArray(byte[] var1, int var2, int var3, BidiConversionProperties var4);

    byte[] decompressSB(char[] cArray, byte by) {
        int n;
        byte[] byArray = new byte[65536];
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            int n3;
            int n4;
            if (cArray[n] == '\uffff') {
                if (cArray.length > n + 1 && cArray[n + 1] == '\u0000') {
                    byArray[n2++] = (byte)(cArray[n] / 256);
                    byArray[n2++] = (byte)(cArray[n++] % 256);
                    continue;
                }
                long l = (0xFFFF & cArray[n + 1] * 2) + (0xFFFF & n2);
                n4 = cArray[n + 2];
                while ((long)n2 < l) {
                    byArray[n2++] = (byte)(n4 / 256);
                    byArray[n2++] = (byte)(n4 % 256);
                }
                n += 2;
                continue;
            }
            if (cArray[n] == '\ufffe') {
                if (cArray.length > n + 1 && cArray[n + 1] == '\u0000') {
                    byArray[n2++] = (byte)(cArray[n] / 256);
                    byArray[n2++] = (byte)(cArray[n++] % 256);
                    continue;
                }
                int n5 = 0xFFFF & cArray[n + 2];
                n3 = 0xFFFF & cArray[n + 1];
                for (n4 = n5; n4 < n3 + n5; ++n4) {
                    byArray[n2++] = (byte)(n4 / 256);
                    byArray[n2++] = (byte)(n4 % 256);
                }
                n += 2;
                continue;
            }
            if (cArray[n] == '\u0000') {
                if (cArray.length > n + 1 && cArray[n + 1] == '\u0000') {
                    byArray[n2++] = (byte)(cArray[n] / 256);
                    byArray[n2++] = (byte)(cArray[n++] % 256);
                    continue;
                }
                int n6 = 0xFFFF & cArray[++n];
                n3 = cArray[++n];
                n4 = (char)(0xFF00 & n3);
                byArray[n2++] = (byte)(n3 / 256);
                byArray[n2++] = (byte)(n3 % 256);
                ++n;
                for (int i = 0; i < n6; ++i) {
                    char c = cArray[n + i];
                    char c2 = (char)(n4 + ((0xFF00 & c) >>> 8));
                    char c3 = (char)(n4 + (0xFF & c));
                    byArray[n2++] = (byte)(c2 / 256);
                    byArray[n2++] = (byte)(c2 % 256);
                    byArray[n2++] = (byte)(c3 / 256);
                    byArray[n2++] = (byte)(c3 % 256);
                }
                n = n + n6 - 1;
                continue;
            }
            byArray[n2++] = (byte)(cArray[n] / 256);
            byArray[n2++] = (byte)(cArray[n] % 256);
        }
        for (n = n2; n < byArray.length; ++n) {
            byArray[n] = by;
        }
        return byArray;
    }

    static final byte[] dumpCharArray(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n4++] = (byte)(cArray[n3] >> 8);
            byArray[n4++] = (byte)cArray[n3++];
        }
        return byArray;
    }

    static final byte[] dumpCharArray(char[] cArray, int n) {
        return ConvTable.dumpCharArray(cArray, 0, n);
    }

    static final byte[] dumpCharArray(char[] cArray) {
        return ConvTable.dumpCharArray(cArray, cArray.length);
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public static final ConvTable getTable(String string) throws UnsupportedEncodingException {
        String string2 = NLS.forceJavaTables_ ? string : prefix_ + ConversionMaps.encodingToCcsidString(string);
        ConvTable convTable = (ConvTable)converterPool_.get(string2);
        if (convTable != null) {
            if (Trace.traceOn_) {
                Trace.log(5, "Reusing previously loaded conversion table for encoding: " + string);
            }
            return convTable;
        }
        try {
            if (NLS.forceJavaTables_) {
                if (Trace.traceOn_) {
                    Trace.log(5, "User set to force loading Java tables.");
                }
                throw new CharConversionException();
            }
            convTable = (ConvTable)Class.forName(string2).newInstance();
        }
        catch (Throwable throwable) {
            if (Trace.traceOn_) {
                Trace.log(5, "Could not load conversion table class for encoding: " + string + ". Will attempt to let Java do the conversion.", throwable);
            }
            if ((convTable = (ConvTable)converterPool_.get(string2 = string)) != null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Reusing previously loaded Java conversion table for encoding: " + string);
                }
                return convTable;
            }
            convTable = new ConvTableJavaMap(string);
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded conversion table for encoding: " + string);
        }
        converterPool_.put(string2, convTable);
        return convTable;
    }

    public static final ConvTable getTable(int n, AS400ImplRemote aS400ImplRemote) throws UnsupportedEncodingException {
        ConvTable convTable;
        Object object;
        if (n > 2000000 ? (object = ccsidPool2_[n - 2000000]) != null : (n > 1000000 ? (object = ccsidPool1_[n - 1000000]) != null : (n &= 0xFFFF) <= 62251 && (object = ccsidPool_[n]) != null)) {
            return object;
        }
        object = null;
        if (NLS.forceJavaTables_) {
            object = ConversionMaps.ccsidToEncoding(n);
            if (object == null) {
                object = "";
            }
        } else {
            object = prefix_ + String.valueOf(n);
        }
        if ((convTable = (ConvTable)converterPool_.get(object)) != null) {
            if (Trace.traceOn_) {
                Trace.log(5, "Reusing previously loaded conversion table for ccsid: " + n);
            }
            if (n > 2000000) {
                ConvTable.ccsidPool2_[n - 2000000] = convTable;
            } else if (n > 1000000) {
                ConvTable.ccsidPool1_[n - 1000000] = convTable;
            } else if (n <= 62251) {
                ConvTable.ccsidPool_[n] = convTable;
            }
            return convTable;
        }
        try {
            if (NLS.forceJavaTables_) {
                if (Trace.traceOn_) {
                    Trace.log(5, "User set to force loading Java tables.");
                }
                throw new CharConversionException();
            }
            convTable = (ConvTable)Class.forName((String)object).newInstance();
        }
        catch (Throwable throwable) {
            if (Trace.traceOn_) {
                Trace.log(5, "Could not load conversion table class for ccsid: " + n + ". Will attempt to let Java do the conversion.", throwable);
            }
            if ((object = ConversionMaps.ccsidToEncoding(n)) == null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Could not find an encoding that matches ccsid: " + n);
                }
                UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException("CCSID " + n);
                unsupportedEncodingException.initCause(throwable);
                throw unsupportedEncodingException;
            }
            convTable = (ConvTable)converterPool_.get(object);
            if (convTable != null) {
                if (Trace.traceOn_) {
                    Trace.log(5, "Reusing previously loaded Java conversion table for ccsid: " + n);
                }
                if (n <= 62251) {
                    ConvTable.ccsidPool_[n] = convTable;
                }
                return convTable;
            }
            convTable = new ConvTableJavaMap((String)object);
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded conversion table for ccsid: " + n);
        }
        converterPool_.put(object, convTable);
        if (n <= 62251) {
            ConvTable.ccsidPool_[n] = convTable;
        }
        if (aS400ImplRemote != null) {
            convTable.clientBidiStringType = aS400ImplRemote.getBidiStringType();
        }
        return convTable;
    }

    public byte[] stringToByteArray(String string, int n) {
        return this.stringToByteArray(string, new BidiConversionProperties(n));
    }

    abstract byte[] stringToByteArray(String var1, BidiConversionProperties var2);

    public byte[] stringToByteArray(String string) {
        return this.stringToByteArray(string, new BidiConversionProperties(this.bidiStringType_));
    }

    public byte[] stringToByteArray(char[] cArray, int n, int n2) {
        return this.stringToByteArray(new String(cArray, n, n2));
    }

    public void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        byte[] byArray2 = this.stringToByteArray(string, new BidiConversionProperties(this.bidiStringType_));
        try {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
    }

    public void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties(this.bidiStringType_));
    }

    public void stringToByteArray(String string, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties(n3));
    }

    public int stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        int n3 = 0;
        byte[] byArray2 = this.stringToByteArray(string, bidiConversionProperties);
        if (n2 >= byArray2.length) {
            n2 = byArray2.length;
        } else if (n2 < this.stringToByteArray(string.trim(), bidiConversionProperties).length) {
            n3 = byArray2.length - n2;
        }
        try {
            System.arraycopy(byArray2, 0, byArray, n, n2);
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Trace.log(5, "Source length: " + byArray2.length + "; Source offset: 0; Destination length: " + byArray.length + "; Destination offset: " + n + "; Number of bytes to copy: " + n2, (Throwable)arrayIndexOutOfBoundsException);
            throw new CharConversionException();
        }
    }

    abstract byte[] charArrayToByteArray(char[] var1, BidiConversionProperties var2);

    public byte[] charArrayToByteArray(char[] cArray, int n) {
        return this.charArrayToByteArray(cArray, new BidiConversionProperties(n));
    }

    public byte[] charArrayToByteArray(char[] cArray) {
        return this.charArrayToByteArray(cArray, new BidiConversionProperties(this.bidiStringType_));
    }

    public void charArrayToByteArray(char[] cArray, byte[] byArray, int n) throws CharConversionException {
        byte[] byArray2 = this.charArrayToByteArray(cArray, new BidiConversionProperties(this.bidiStringType_));
        try {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
    }

    public void charArrayToByteArray(char[] cArray, byte[] byArray, int n, int n2) throws CharConversionException {
        this.charArrayToByteArray(cArray, byArray, n, n2, new BidiConversionProperties(this.bidiStringType_));
    }

    public void charArrayToByteArray(char[] cArray, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        this.charArrayToByteArray(cArray, byArray, n, n2, new BidiConversionProperties(n3));
    }

    public int charArrayToByteArray(char[] cArray, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        int n3 = 0;
        byte[] byArray2 = this.charArrayToByteArray(cArray, bidiConversionProperties);
        if (n2 >= byArray2.length) {
            n2 = byArray2.length;
        } else if (n2 < this.charArrayToByteArray(cArray, bidiConversionProperties).length) {
            n3 = byArray2.length - n2;
        }
        try {
            System.arraycopy(byArray2, 0, byArray, n, n2);
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Trace.log(5, "Source length: " + byArray2.length + "; Source offset: 0; Destination length: " + byArray.length + "; Destination offset: " + n + "; Number of bytes to copy: " + n2, (Throwable)arrayIndexOutOfBoundsException);
            throw new CharConversionException();
        }
    }

    public int validateData(byte[] byArray, int n, int n2) {
        return n2;
    }

    public static boolean isMixedCCSID(int n) {
        switch (n) {
            case 930: 
            case 933: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 1208: 
            case 1364: 
            case 1371: 
            case 1377: 
            case 1379: 
            case 1388: 
            case 1390: 
            case 1399: 
            case 5026: 
            case 5035: 
            case 5473: 
            case 13676: {
                return true;
            }
        }
        return false;
    }
}

