/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

public abstract class ConvTableBidiMap
extends ConvTable {
    public char[] toUnicode_ = null;
    public byte[] fromUnicode_ = null;

    ConvTableBidiMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.ccsid_ = n;
        this.toUnicode_ = cArray;
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing bidi single-byte conversion table for ccsid: " + this.ccsid_, cArray2.length);
        }
        this.fromUnicode_ = this.decompressSB(cArray2, (byte)63);
        this.bidiStringType_ = AS400BidiTransform.getStringType(n);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded bidi single-byte map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        int n3 = bidiConversionProperties.getBidiStringType();
        if (Trace.traceConversion_) {
            Trace.log(5, "Bidi String Type: " + n3);
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = this.toUnicode_[0xFF & byArray[n + n4++]];
        }
        if (n3 == -1) {
            if (Trace.traceConversion_) {
                Trace.log(5, "Destination string (no java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
            }
            return String.copyValueOf(cArray);
        }
        AS400BidiTransform aS400BidiTransform = new AS400BidiTransform(this.ccsid_);
        aS400BidiTransform.setBidiConversionProperties(bidiConversionProperties);
        aS400BidiTransform.setJavaStringType(bidiConversionProperties.getBidiStringType());
        aS400BidiTransform.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        String string = aS400BidiTransform.toJavaLayout(String.copyValueOf(cArray));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray()));
        }
        return string;
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        return this.charArrayToByteArray(string.toCharArray(), bidiConversionProperties);
    }

    final char[] byteArrayToCharArray(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        int n3 = bidiConversionProperties.getBidiStringType();
        if (Trace.traceConversion_) {
            Trace.log(5, "Bidi String Type: " + n3);
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = this.toUnicode_[0xFF & byArray[n + n4++]];
        }
        if (n3 == -1) {
            if (Trace.traceConversion_) {
                Trace.log(5, "Destination string (no java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
            }
            return cArray;
        }
        AS400BidiTransform aS400BidiTransform = new AS400BidiTransform(this.ccsid_);
        aS400BidiTransform.setBidiConversionProperties(bidiConversionProperties);
        aS400BidiTransform.setJavaStringType(bidiConversionProperties.getBidiStringType());
        aS400BidiTransform.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        char[] cArray2 = aS400BidiTransform.toJavaLayout(cArray);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray2));
        }
        return cArray2;
    }

    final byte[] charArrayToByteArray(char[] cArray, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        AS400BidiTransform aS400BidiTransform = new AS400BidiTransform(this.ccsid_);
        aS400BidiTransform.setBidiConversionProperties(bidiConversionProperties);
        aS400BidiTransform.setJavaStringType(bidiConversionProperties.getBidiStringType());
        aS400BidiTransform.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        cArray = aS400BidiTransform.toAS400Layout(cArray);
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = this.fromUnicode_[cArray[n++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }
}

