/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

abstract class CredentialVault
implements Cloneable,
Serializable {
    static final boolean PASSWORD_TRACE = false;
    static Random rng = new Random();
    protected byte[] encodedCredential_;
    private boolean externalSeedsWereUsed_;

    protected CredentialVault() {
        this(null);
    }

    protected CredentialVault(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault(byte[] credential) called");
        }
        this.encodedCredential_ = (byte[])(byArray == null ? null : this.store(byArray));
        this.externalSeedsWereUsed_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        CredentialVault credentialVault;
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault clone called");
        }
        try {
            credentialVault = (CredentialVault)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, cloneNotSupportedException);
            throw new InternalErrorException(10, (Throwable)cloneNotSupportedException);
        }
        CredentialVault credentialVault2 = this;
        synchronized (credentialVault2) {
            if (this.encodedCredential_ != null) {
                byte[] byArray = new byte[this.encodedCredential_.length];
                System.arraycopy(this.encodedCredential_, 0, byArray, 0, byArray.length);
                credentialVault.encodedCredential_ = byArray;
            }
            credentialVault.externalSeedsWereUsed_ = this.externalSeedsWereUsed_;
        }
        return credentialVault;
    }

    protected abstract int getType();

    protected synchronized void empty() {
        this.disposeOfCredential();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.empty();
        }
        finally {
            super.finalize();
        }
    }

    protected boolean isEmpty() {
        return this.encodedCredential_ == null;
    }

    protected synchronized byte[] getClearCredential() {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.getClearCredential called");
        }
        if (this.isEmpty()) {
            Trace.log(2, "Credential vault is empty");
            throw new ExtendedIllegalStateException("credential", 4);
        }
        return this.resolve(this.encodedCredential_);
    }

    protected synchronized void storeEncodedUsingExternalSeeds(byte[] byArray, byte[] byArray2) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.storedEncodedUsingExternalSeeds called");
        }
        if (this.externalSeedsWereUsed_) {
            Trace.log(2, "Called storeEncodedUsingExternalSeeds() when credential was already encoded using external seeds.");
            throw new InternalErrorException(6);
        }
        this.externalSeedsWereUsed_ = true;
        if (!this.isEmpty()) {
            byte[] byArray3 = this.getClearCredential();
            this.encodedCredential_ = CredentialVault.encode(byArray, byArray2, byArray3);
            CredentialVault.clearArray(byArray3);
        }
    }

    protected synchronized void storeEncodedUsingInternalSeeds(byte[] byArray, byte[] byArray2) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.storedEncodedUsingInternalSeeds called");
        }
        if (!this.externalSeedsWereUsed_) {
            Trace.log(2, "Called storeEncodedUsingInternalSeeds() when credential was not previously encoded using external seeds.");
            throw new InternalErrorException(6);
        }
        this.externalSeedsWereUsed_ = false;
        if (!this.isEmpty()) {
            byte[] byArray3 = CredentialVault.decode(byArray, byArray2, this.encodedCredential_);
            this.encodedCredential_ = this.store(byArray3);
            CredentialVault.clearArray(byArray3);
        }
    }

    protected void disposeOfCredential() {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.disposeOfCredential called");
        }
        this.encodedCredential_ = null;
    }

    protected byte[] store(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        rng.nextBytes(byArray2);
        byte[] byArray3 = new byte[7];
        rng.nextBytes(byArray3);
        byte[] byArray4 = CredentialVault.encode(byArray2, byArray3, byArray);
        byte[] byArray5 = new byte[byArray4.length + 16];
        System.arraycopy(byArray2, 0, byArray5, 0, 9);
        System.arraycopy(byArray3, 0, byArray5, 9, 7);
        System.arraycopy(byArray4, 0, byArray5, 16, byArray4.length);
        return byArray5;
    }

    protected synchronized byte[] resolve(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[9];
        System.arraycopy(byArray, 0, byArray2, 0, 9);
        byte[] byArray3 = new byte[7];
        System.arraycopy(byArray, 9, byArray3, 0, 7);
        byte[] byArray4 = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, byArray4, 0, byArray.length - 16);
        return CredentialVault.decode(byArray2, byArray3, byArray4);
    }

    protected static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        if (byArray3 == null) {
            return null;
        }
        int n2 = byArray3.length;
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray3[n] + byArray[n % 9]);
        }
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray4[n] ^ byArray2[n % 7]);
        }
        return byArray4;
    }

    protected static byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2 = byArray3.length;
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray2[n % 7] ^ byArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray4[n] - byArray[n % 9]);
        }
        return byArray4;
    }

    protected byte[] decode(byte[] byArray, byte[] byArray2) {
        return CredentialVault.decode(byArray, byArray2, this.encodedCredential_);
    }

    protected String trace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type=");
        stringBuffer.append(this.getType());
        stringBuffer.append(" : bytes=");
        Trace.printByteArray(stringBuffer, this.encodedCredential_);
        return stringBuffer.toString();
    }

    public static void clearArray(char[] cArray) {
        Arrays.fill(cArray, '\u0000');
    }

    public static void clearArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public static boolean isStarCurrent(char[] cArray) {
        return !(cArray.length != 8 || cArray[0] != '*' || cArray[1] != 'C' && cArray[1] != 'c' || cArray[2] != 'U' && cArray[2] != 'u' || cArray[3] != 'R' && cArray[3] != 'r' || cArray[4] != 'R' && cArray[4] != 'r' || cArray[5] != 'E' && cArray[5] != 'e' || cArray[6] != 'N' && cArray[6] != 'n' || cArray[7] != 'T' && cArray[7] != 't');
    }

    public static int getHashCode(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = cArray[i] * 31 ^ n - 1;
        }
        return n2;
    }
}

