/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSObjAttrs1;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

class IFSLookupRep
extends IFSDataStream {
    private static final String copyright = "Copyright (C) 2004-2004 International Business Machines Corporation and others.";
    private static final int LLCP_LENGTH = 6;
    private static final int TEMPLATE_LENGTH_OFFSET = 16;
    private static final int OBJECT_HANDLE_OFFSET = 22;
    static final int OA_NONE = 0;
    static final int OA1 = 1;
    static final int OA2 = 2;

    IFSLookupRep() {
    }

    int getHandle() {
        return this.get32bit(22);
    }

    int getASP() throws UnsupportedEncodingException {
        return new IFSObjAttrs1(this.getObjAttrBytes(1)).getASP();
    }

    int getCCSID(int n) {
        return new IFSObjAttrs2(this.getObjAttrBytes(2)).getCCSID(n);
    }

    String getOwnerName(int n) throws UnsupportedEncodingException {
        return new IFSObjAttrs1(this.getObjAttrBytes(1)).getOwnerName(n);
    }

    public Object getNewDataStream() {
        return new IFSLookupRep();
    }

    public int hashCode() {
        return 32780;
    }

    private final byte[] getObjAttrBytes(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = 20 + this.get16bit(16);
        short s = n == 1 ? (short)16 : 15;
        byte[] byArray = null;
        while (byArray == null && n2 < this.data_.length) {
            int n3 = this.get32bit(n2);
            short s2 = (short)this.get16bit(n2 + 4);
            if (s2 == s) {
                int n4 = n3 - 6;
                byArray = new byte[n4];
                System.arraycopy(this.data_, n2 + 6, byArray, 0, n4);
                continue;
            }
            n2 += n3;
        }
        if (byArray == null) {
            Trace.log(2, "The reply does not contain an OA" + n + " structure.");
            throw new InternalErrorException(6);
        }
        return byArray;
    }
}

