/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ISeriesNetServerConnection;
import com.ibm.as400.access.ISeriesNetServerFileShare;
import com.ibm.as400.access.ISeriesNetServerPrintShare;
import com.ibm.as400.access.ISeriesNetServerSession;
import com.ibm.as400.access.ISeriesNetServerShare;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ISeriesNetServer
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int ENCRYPTED_PASSWORDS = 0;
    public static final int NETWORK_AUTHENTICATION = 1;
    public static final int KERBEROS_V5_TOKENS = 1;
    public static final int NETWORK_AUTHENTICATION_OR_PASSWORDS = 2;
    public static final int KERBEROS_OR_PASSWORDS = 2;
    public static final int NO_AUTO_DISCONNECT = -1;
    public static final int OPP_LOCK_DISABLED = -1;
    public static final int MSG_AUTH_NOT_SUPPORTED = 0;
    public static final int MSG_AUTH_NEGOTIATED = 1;
    public static final int MSG_AUTH_REQUIRED = 2;
    public static final int NO_ADMIN_ALERTS = -1;
    public static final int PASSWORD_STRONGER = 0;
    public static final int PASSWORD_STRONGER_OR_MISMATCH = 1;
    private static final int BOTH = 2;
    private static final int FILE = 0;
    private static final int PRINT = 1;
    private AS400 system_;
    private int systemVRM_;
    private boolean gotSystemVRM_;
    private static final int ALLOW_SYSTEM_NAME = 0;
    private static final int AUTHENTICATION_METHOD = 1;
    private static final int AUTOSTART = 2;
    private static final int DESCRIPTION = 3;
    private static final int DOMAIN_NAME = 4;
    private static final int GUEST_USER_PROFILE = 5;
    private static final int SERVER_NAME = 6;
    private static final int WINS_PRIMARY_ADDRESS = 7;
    private static final int WINS_SCOPE_ID = 8;
    private static final int WINS_SECONDARY_ADDRESS = 9;
    private static final int BROWSING_INTERVAL = 20;
    private static final int CCSID = 21;
    private static final int IDLE_TIMEOUT = 22;
    private static final int LOGON_SUPPORT = 23;
    private static final int OPP_LOCK_TIMEOUT = 24;
    private static final int WINS_ENABLEMENT = 25;
    private static final int MESSAGE_AUTHENTICATION = 26;
    private static final int MIN_MESSAGE_SEVERITY = 27;
    private static final int LAN_MGR_AUTHENTICATION = 28;
    private static final int ENCRYPTED_CONNECTION_ENFORCE = 29;
    private static final int SERVER_AUTHORIZATION_LIST = 30;
    private static final int MAX_ATTR = 30;
    private static final int ZLSL0101_MAX_RECORD_LENGTH = 1221;
    private static final int ZLSL0101_MAX_RECORD_LENGTH_74 = 1223;
    private static final int ZLSL0101_MAX_RECORD_LENGTH_75 = 1233;
    private String[] effectiveValueStr_ = new String[31];
    private String[] pendingValueStr_ = new String[31];
    private int[] effectiveValueInt_ = new int[31];
    private int[] pendingValueInt_ = new int[31];
    private boolean[] userChangedAttribute_ = new boolean[31];
    private boolean[] userCommittedChange_ = new boolean[31];
    private transient boolean refreshedSinceStart_ = false;
    private boolean changedAutoStartSinceRefresh_ = false;
    private transient boolean determinedSpecialAuthority_ = false;
    private transient boolean userHasSpecialAuthority_ = false;
    private static final boolean DEBUG = false;
    private static boolean IBMi74 = false;
    private static boolean IBMi75 = false;

    public ISeriesNetServer(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException();
        }
        this.system_ = aS400;
    }

    public void createFileShare(String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(string, string2, "", 1, -1);
    }

    public void createFileShare(String string, String string2, String string3, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(string, string2, string3, n, -1);
    }

    public void createFileShare(String string, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createFileShare(string, string2, string3, 1, -1);
    }

    public void createFileShare(String string, String string2, String string3, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("shareName");
        }
        if (string2 == null) {
            throw new NullPointerException("path");
        }
        if (string3 == null) {
            string3 = "";
        }
        int n3 = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(12, n3);
        AS400Text aS400Text2 = new AS400Text(50, n3);
        byte[] byArray = string2.trim().getBytes("UnicodeBigUnmarked");
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes(string.trim())), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(byArray.length)), new ProgramParameter(BinaryConverter.intToByteArray(13488)), new ProgramParameter(aS400Text2.toBytes(string3)), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSADFS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public void createPrintShare(String string, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(string, string2, string3, "", 4, null, null, null, false);
    }

    public void createPrintShare(String string, String string2, String string3, String string4, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(string, string2, string3, string4, n, null, null, null, false);
    }

    public void createPrintShare(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.createPrintShare(string, string2, string3, string4, n, string5, string6, string7, false);
    }

    public void createPrintShare(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("shareName");
        }
        if (string2 == null) {
            throw new NullPointerException("outqLib");
        }
        if (string3 == null) {
            throw new NullPointerException("outqName");
        }
        if (string4 == null) {
            string4 = "";
        }
        if (n < 1 || n > 4) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string6 == null) {
            string6 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        int n2 = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(12, n2);
        AS400Text aS400Text2 = new AS400Text(10, n2);
        AS400Text aS400Text3 = new AS400Text(50, n2);
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[1];
        aS400Text2.toBytes(string2, byArray, 10);
        aS400Text2.toBytes(string3, byArray, 0);
        aS400Text2.toBytes(string6, byArray2, 10);
        aS400Text2.toBytes(string7, byArray2, 0);
        byArray3[0] = bl ? -15 : -16;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes(string.trim())), new ProgramParameter(byArray), new ProgramParameter(aS400Text3.toBytes(string4)), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(aS400Text3.toBytes(string5)), new ErrorCodeParameter(), new ProgramParameter(byArray2), new ProgramParameter(byArray3)};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSADPS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private final int getSystemVRM() throws AS400SecurityException, IOException {
        if (!this.gotSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.gotSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    public ISeriesNetServerFileShare[] listFileShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerFileShare[])this.listShares(0, null);
    }

    public ISeriesNetServerFileShare[] listFileShares(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (ISeriesNetServerFileShare[])this.listShares(0, string);
    }

    public ISeriesNetServerPrintShare[] listPrintShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerPrintShare[])this.listShares(1, null);
    }

    public ISeriesNetServerPrintShare[] listPrintShares(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (ISeriesNetServerPrintShare[])this.listShares(1, string);
    }

    public ISeriesNetServerShare[] listShares() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (ISeriesNetServerShare[])this.listShares(2, "*ALL");
    }

    private Object listShares(int n, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            string = "*ALL";
        }
        int n2 = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n2);
        AS400Text aS400Text = new AS400Text(15, n2);
        int n3 = 8192;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0101")), new ProgramParameter(aS400Text.toBytes(string.trim())), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n4 = ISeriesNetServer.callListProgram(programCall, programParameterArray, n3);
        byte[] byArray = programParameterArray[0].getOutputData();
        if (this.getSystemVRM() >= 459776) {
            IBMi74 = true;
        }
        if (this.getSystemVRM() >= 460032) {
            IBMi75 = true;
        }
        return ISeriesNetServer.parseZLSL0101(byArray, charConverter, n4, n, null);
    }

    private static int callListProgram(ProgramCall programCall, ProgramParameter[] programParameterArray, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[2].getOutputData();
        int n2 = BinaryConverter.byteArrayToInt(byArray, 0);
        int n3 = BinaryConverter.byteArrayToInt(byArray, 4);
        if (Trace.isTraceOn() && n3 < n2) {
            Trace.log(1, "Returned info is incomplete on first API call.");
        }
        while (n3 < n2) {
            int n4 = BinaryConverter.byteArrayToInt(byArray, 8);
            n = n4 > 0 ? (n += n4 * n2) : (n *= 1 + n2 / n3);
            try {
                programParameterArray[0].setOutputDataLength(n);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n));
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray = programParameterArray[2].getOutputData();
            n2 = BinaryConverter.byteArrayToInt(byArray, 0);
            n3 = BinaryConverter.byteArrayToInt(byArray, 4);
        }
        return n3;
    }

    public ISeriesNetServerSession[] listSessions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.listSessionsForWorkstation("*ALL");
    }

    public ISeriesNetServerSession[] listSessionsForWorkstation(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Serializable serializable;
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        int n2 = this.getSystemVRM();
        int n3 = n2 < 393472 ? 64 : 192;
        int n4 = 20 * n3;
        ProgramParameter[] programParameterArray = new ProgramParameter[n2 < 393472 ? 6 : 8];
        programParameterArray[0] = new ProgramParameter(n4);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n4));
        programParameterArray[2] = new ProgramParameter(64);
        programParameterArray[3] = new ProgramParameter(charConverter.stringToByteArray("ZLSL0300"));
        if (n2 < 393472) {
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes(string));
        } else {
            serializable = new AS400Text(10, n);
            AS400Text aS400Text2 = new AS400Text(50, n);
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes("*EXPANDED"));
            programParameterArray[6] = new ProgramParameter(((AS400Text)serializable).toBytes("*ALL"));
            programParameterArray[7] = new ProgramParameter(aS400Text2.toBytes(string));
        }
        programParameterArray[5] = new ErrorCodeParameter();
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n5 = ISeriesNetServer.callListProgram((ProgramCall)serializable, programParameterArray, n4);
        byte[] byArray = programParameterArray[0].getOutputData();
        ISeriesNetServerSession[] iSeriesNetServerSessionArray = new ISeriesNetServerSession[n5];
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            ISeriesNetServerSession iSeriesNetServerSession;
            iSeriesNetServerSessionArray[i] = iSeriesNetServerSession = this.parseZLSL0300(byArray, n6, charConverter, null);
            if (this.getSystemVRM() < 393472) {
                n6 += 64;
                continue;
            }
            n6 += 192;
        }
        return iSeriesNetServerSessionArray;
    }

    public ISeriesNetServerConnection[] listConnectionsForSession(long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(10, n);
        AS400Text aS400Text2 = new AS400Text(15, n);
        int n2 = 1280;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0600")), new ProgramParameter(aS400Text2.toBytes("*SESSID")), new ErrorCodeParameter(), new ProgramParameter(aS400Text.toBytes("*SESSID")), new ProgramParameter(BinaryConverter.longToByteArray(l))};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n3 = ISeriesNetServer.callListProgram(programCall, programParameterArray, n2);
        ISeriesNetServerConnection[] iSeriesNetServerConnectionArray = new ISeriesNetServerConnection[n3];
        int n4 = 0;
        byte[] byArray = programParameterArray[0].getOutputData();
        for (int i = 0; i < n3; ++i) {
            ISeriesNetServerConnection iSeriesNetServerConnection;
            iSeriesNetServerConnectionArray[i] = iSeriesNetServerConnection = this.parseZLSL0600or0700(byArray, n4, charConverter, true, null);
            n4 += 64;
        }
        return iSeriesNetServerConnectionArray;
    }

    public ISeriesNetServerConnection[] listConnectionsForSession(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Serializable serializable;
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        int n2 = 1280;
        int n3 = this.getSystemVRM();
        ProgramParameter[] programParameterArray = new ProgramParameter[n3 < 393472 ? 6 : 8];
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[2] = new ProgramParameter(64);
        programParameterArray[3] = new ProgramParameter(charConverter.stringToByteArray("ZLSL0600"));
        if (n3 < 393472) {
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes(string));
        } else {
            serializable = new AS400Text(50, n);
            AS400Text aS400Text2 = new AS400Text(10, n);
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes("*EXPANDED"));
            programParameterArray[6] = new ProgramParameter(aS400Text2.toBytes("*ALL"));
            programParameterArray[7] = new ProgramParameter(((AS400Text)serializable).toBytes(string));
        }
        programParameterArray[5] = new ErrorCodeParameter();
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n4 = ISeriesNetServer.callListProgram((ProgramCall)serializable, programParameterArray, n2);
        ISeriesNetServerConnection[] iSeriesNetServerConnectionArray = new ISeriesNetServerConnection[n4];
        int n5 = 0;
        byte[] byArray = programParameterArray[0].getOutputData();
        for (int i = 0; i < n4; ++i) {
            ISeriesNetServerConnection iSeriesNetServerConnection;
            iSeriesNetServerConnectionArray[i] = iSeriesNetServerConnection = this.parseZLSL0600or0700(byArray, n5, charConverter, true, null);
            n5 += 64;
        }
        return iSeriesNetServerConnectionArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ISeriesNetServerShare[] parseZLSL0101(byte[] byArray, CharConverter charConverter, int n, int n2, ISeriesNetServerShare iSeriesNetServerShare) {
        ISeriesNetServerShare[] iSeriesNetServerShareArray;
        int n3;
        ISeriesNetServerFileShare[] iSeriesNetServerFileShareArray = n2 == 0 ? new ISeriesNetServerFileShare[n] : null;
        ISeriesNetServerPrintShare[] iSeriesNetServerPrintShareArray = n2 == 1 ? new ISeriesNetServerPrintShare[n] : null;
        ISeriesNetServerShare[] iSeriesNetServerShareArray2 = n2 == 2 ? new ISeriesNetServerShare[n] : null;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; n5 += n3, ++i) {
            boolean bl;
            String string;
            int n6;
            String string2;
            String string3;
            n3 = BinaryConverter.byteArrayToInt(byArray, n5 + 0);
            int n7 = BinaryConverter.byteArrayToInt(byArray, n5 + 16);
            int n8 = BinaryConverter.byteArrayToInt(byArray, n5 + 24);
            int n9 = BinaryConverter.byteArrayToInt(byArray, n5 + 28);
            String string4 = null;
            String string5 = null;
            if (IBMi74) {
                string4 = charConverter.byteArrayToString(byArray, n5 + 198, 1).trim();
                if (IBMi75) {
                    string5 = charConverter.byteArrayToString(byArray, n5 + 199, 10).trim();
                }
            }
            if (n7 == 0) {
                if (n2 != 0 && n2 != 2) continue;
                string3 = charConverter.byteArrayToString(byArray, n5 + 4, 12).trim();
                string2 = charConverter.byteArrayToString(byArray, n5 + 114, 50).trim();
                n6 = BinaryConverter.byteArrayToInt(byArray, n5 + 20);
                int n10 = BinaryConverter.byteArrayToInt(byArray, n5 + 36);
                int n11 = BinaryConverter.byteArrayToInt(byArray, n5 + 40);
                string = charConverter.byteArrayToString(byArray, n10, n11).trim();
                int n12 = BinaryConverter.byteArrayToInt(byArray, n5 + 184);
                String string6 = charConverter.byteArrayToString(byArray, n5 + 196, 1).trim();
                int n13 = BinaryConverter.byteArrayToInt(byArray, n5 + 188);
                int n14 = BinaryConverter.byteArrayToInt(byArray, n5 + 192);
                String[] stringArray = new String[n14];
                int n15 = n13;
                for (int j = 0; j < n14; n15 += 50, ++j) {
                    int n16 = BinaryConverter.byteArrayToInt(byArray, n15 + 0);
                    stringArray[j] = charConverter.byteArrayToString(byArray, n15 + 4, n16).trim();
                }
                if (iSeriesNetServerShare != null) {
                    ((ISeriesNetServerFileShare)iSeriesNetServerShare).setAttributeValues(string3, n6, n8, n9, string2, string, n12, string6, stringArray, string4, string5);
                    return null;
                }
                ISeriesNetServerFileShare iSeriesNetServerFileShare = new ISeriesNetServerFileShare(string3, n6, n8, n9, string2, string, n12, string6, stringArray, string4, string5);
                if (n2 == 0) {
                    iSeriesNetServerFileShareArray[n4++] = iSeriesNetServerFileShare;
                    continue;
                }
                iSeriesNetServerShareArray2[n4++] = iSeriesNetServerFileShare;
                continue;
            }
            if (n2 != 1 && n2 != 2) continue;
            string3 = charConverter.byteArrayToString(byArray, n5 + 4, 12).trim();
            string2 = charConverter.byteArrayToString(byArray, n5 + 114, 50).trim();
            n6 = BinaryConverter.byteArrayToInt(byArray, n5 + 32);
            String string7 = charConverter.byteArrayToString(byArray, n5 + 44, 20);
            String string8 = charConverter.byteArrayToString(byArray, n5 + 64, 50).trim();
            string = charConverter.byteArrayToString(byArray, n5 + 164, 20);
            String string9 = charConverter.byteArrayToString(byArray, n5 + 197, 1).trim();
            boolean bl2 = bl = string9.equals("1");
            if (iSeriesNetServerShare != null) {
                ((ISeriesNetServerPrintShare)iSeriesNetServerShare).setAttributeValues(string3, n6, string7, string8, string2, string, bl, string4, string5);
                return null;
            }
            ISeriesNetServerPrintShare iSeriesNetServerPrintShare = new ISeriesNetServerPrintShare(string3, n6, string7, string8, string2, string, bl, string4, string5);
            if (n2 == 1) {
                iSeriesNetServerPrintShareArray[n4++] = iSeriesNetServerPrintShare;
                continue;
            }
            iSeriesNetServerShareArray2[n4++] = iSeriesNetServerPrintShare;
        }
        if (n2 == 2) {
            return iSeriesNetServerShareArray2;
        }
        ISeriesNetServerShare[] iSeriesNetServerShareArray3 = iSeriesNetServerShareArray = n2 == 0 ? iSeriesNetServerFileShareArray : iSeriesNetServerPrintShareArray;
        if (n4 >= n) {
            return iSeriesNetServerShareArray;
        }
        ISeriesNetServerShare[] iSeriesNetServerShareArray4 = n2 == 0 ? new ISeriesNetServerFileShare[n4] : new ISeriesNetServerPrintShare[n4];
        System.arraycopy(iSeriesNetServerShareArray, 0, iSeriesNetServerShareArray4, 0, n4);
        return iSeriesNetServerShareArray4;
    }

    private ISeriesNetServerSession parseZLSL0300(byte[] byArray, int n, CharConverter charConverter, ISeriesNetServerSession iSeriesNetServerSession) throws AS400SecurityException, IOException {
        boolean bl;
        String string = this.getSystemVRM() < 393472 ? charConverter.byteArrayToString(byArray, n + 0, 15).trim() : charConverter.byteArrayToString(byArray, n + 68, 124).trim();
        String string2 = charConverter.byteArrayToString(byArray, n + 15, 10).trim();
        int n2 = BinaryConverter.byteArrayToInt(byArray, n + 28);
        int n3 = BinaryConverter.byteArrayToInt(byArray, n + 32);
        int n4 = BinaryConverter.byteArrayToInt(byArray, n + 40);
        int n5 = BinaryConverter.byteArrayToInt(byArray, n + 44);
        String string3 = charConverter.byteArrayToString(byArray, n + 48, 1).trim();
        String string4 = charConverter.byteArrayToString(byArray, n + 49, 1).trim();
        long l = BinaryConverter.byteArrayToLong(byArray, n + 56);
        boolean bl2 = string4.equals("1");
        boolean bl3 = bl = string3.equals("0");
        if (iSeriesNetServerSession == null) {
            iSeriesNetServerSession = new ISeriesNetServerSession(string, l, n2, n4, n3, n5, bl2, bl, string2);
        } else {
            iSeriesNetServerSession.setAttributeValues(string, l, n2, n4, n3, n5, bl2, bl, string2);
        }
        return iSeriesNetServerSession;
    }

    private ISeriesNetServerConnection parseZLSL0600or0700(byte[] byArray, int n, CharConverter charConverter, boolean bl, ISeriesNetServerConnection iSeriesNetServerConnection) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n2;
        String string;
        int n3 = BinaryConverter.byteArrayToInt(byArray, n + 0);
        int n4 = BinaryConverter.byteArrayToInt(byArray, n + 4);
        int n5 = BinaryConverter.byteArrayToInt(byArray, n + 8);
        int n6 = BinaryConverter.byteArrayToInt(byArray, n + 12);
        int n7 = BinaryConverter.byteArrayToInt(byArray, n + 16);
        String string2 = charConverter.byteArrayToString(byArray, n + 20, 10).trim();
        if (bl) {
            string = charConverter.byteArrayToString(byArray, n + 30, 12).trim();
            n2 = 1;
        } else {
            string = this.getSystemVRM() < 393472 ? charConverter.byteArrayToString(byArray, n + 30, 15).trim() : charConverter.byteArrayToString(byArray, n + 68, 124).trim();
            n2 = 0;
        }
        long l = this.getSystemVRM() >= 327936 ? BinaryConverter.byteArrayToLong(byArray, n + 48) : 0L;
        if (iSeriesNetServerConnection == null) {
            iSeriesNetServerConnection = new ISeriesNetServerConnection(n3, n7, n5, n4, string, n2, string2, n6, l);
        } else {
            iSeriesNetServerConnection.setAttributeValues(n3, n7, n5, n4, string, n2, string2, n6, l);
        }
        return iSeriesNetServerConnection;
    }

    public ISeriesNetServerConnection[] listConnectionsForShare(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        int n2 = this.getSystemVRM() < 393472 ? 64 : 192;
        int n3 = 20 * n2;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0700")), new ProgramParameter(aS400Text.toBytes(string)), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n4 = ISeriesNetServer.callListProgram(programCall, programParameterArray, n3);
        ISeriesNetServerConnection[] iSeriesNetServerConnectionArray = new ISeriesNetServerConnection[n4];
        int n5 = 0;
        byte[] byArray = programParameterArray[0].getOutputData();
        for (int i = 0; i < n4; ++i) {
            ISeriesNetServerConnection iSeriesNetServerConnection;
            iSeriesNetServerConnectionArray[i] = iSeriesNetServerConnection = this.parseZLSL0600or0700(byArray, n5, charConverter, false, null);
            if (this.getSystemVRM() < 393472) {
                n5 += 64;
                continue;
            }
            n5 += 192;
        }
        return iSeriesNetServerConnectionArray;
    }

    public void removeShare(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(12, n);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes(string.trim())), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSRMS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public boolean isAllowSystemName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[0].equals("1");
    }

    public boolean isAllowSystemNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[0].equals("1");
    }

    public void setAllowSystemName(boolean bl) {
        this.pendingValueStr_[0] = bl ? "1" : "0";
        this.userChangedAttribute_[0] = true;
        this.userCommittedChange_[0] = false;
    }

    public int getAuthenticationMethod() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        switch (this.effectiveValueStr_[1].charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public int getAuthenticationMethodPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        switch (this.pendingValueStr_[1].charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public void setAuthenticationMethod(int n) {
        char[] cArray = new char[1];
        switch (n) {
            case 0: {
                cArray[0] = 48;
                break;
            }
            case 1: {
                cArray[0] = 49;
                break;
            }
            case 2: {
                cArray[0] = 50;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
            }
        }
        this.pendingValueStr_[1] = new String(cArray);
        this.userChangedAttribute_[1] = true;
        this.userCommittedChange_[1] = false;
    }

    public boolean isAutoStart() throws AS400SecurityException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to query the AutoStart attribute.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_ || this.changedAutoStartSinceRefresh_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[2].equals("*YES");
    }

    public boolean isAutoStartPending() throws AS400SecurityException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to query the AutoStart attribute.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_ || this.changedAutoStartSinceRefresh_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[2].equals("*YES");
    }

    public void setAutoStart(boolean bl) {
        this.pendingValueStr_[2] = bl ? "*YES" : "*NO";
        this.userChangedAttribute_[2] = true;
        this.userCommittedChange_[2] = false;
    }

    public int getBrowsingInterval() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[20];
    }

    public int getBrowsingIntervalPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[20];
    }

    public void setBrowsingInterval(int n) {
        this.pendingValueInt_[20] = n;
        this.userChangedAttribute_[20] = true;
        this.userCommittedChange_[20] = false;
    }

    public int getCCSID() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[21];
    }

    public int getCCSIDPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[21];
    }

    public void setCCSID(int n) {
        this.pendingValueInt_[21] = n;
        this.userChangedAttribute_[21] = true;
        this.userCommittedChange_[21] = false;
    }

    public String getDescription() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[3];
    }

    public String getDescriptionPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[3];
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[3] = string.trim();
        this.userChangedAttribute_[3] = true;
        this.userCommittedChange_[3] = false;
    }

    public String getDomainName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[4];
    }

    public String getDomainNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[4];
    }

    public void setDomainName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[4] = string.trim();
        this.userChangedAttribute_[4] = true;
        this.userCommittedChange_[4] = false;
    }

    public String getGuestUserProfile() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[5];
    }

    public String getGuestUserProfilePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[5];
    }

    public void setGuestUserProfile(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[5] = string.trim();
        this.userChangedAttribute_[5] = true;
        this.userCommittedChange_[5] = false;
    }

    public int getIdleTimeout() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[22];
    }

    public int getIdleTimeoutPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[22];
    }

    public void setIdleTimeout(int n) {
        this.pendingValueInt_[22] = n;
        this.userChangedAttribute_[22] = true;
        this.userCommittedChange_[22] = false;
    }

    public int getLANManagerAuthentication() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[28];
    }

    public int getLANManagerAuthenticationPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[28];
    }

    public void setLANManagerAuthentication(int n) {
        this.pendingValueInt_[28] = n;
        this.userChangedAttribute_[28] = true;
        this.userCommittedChange_[28] = false;
    }

    public boolean isLogonServer() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[23] == 1;
    }

    public boolean isLogonServerPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[23] == 1;
    }

    public void setLogonServer(boolean bl) {
        this.pendingValueInt_[23] = bl ? 1 : 0;
        this.userChangedAttribute_[23] = true;
        this.userCommittedChange_[23] = false;
    }

    public int getMessageAuthentication() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[26];
    }

    public int getMessageAuthenticationPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[26];
    }

    public void setMessageAuthentication(int n) {
        this.pendingValueInt_[26] = n;
        this.userChangedAttribute_[26] = true;
        this.userCommittedChange_[26] = false;
    }

    public int getMinimumMessageSeverity() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[27];
    }

    public int getMinimumMessageSeverityPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[27];
    }

    public void setMinimumMessageSeverity(int n) {
        this.pendingValueInt_[27] = n;
        this.userChangedAttribute_[27] = true;
        this.userCommittedChange_[27] = false;
    }

    public String getName() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[6];
    }

    public String getNamePending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[6];
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[6] = string.trim();
        this.userChangedAttribute_[6] = true;
        this.userCommittedChange_[6] = false;
    }

    public int getOpportunisticLockTimeout() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[24];
    }

    public int getOpportunisticLockTimeoutPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[24];
    }

    public void setOpportunisticLockTimeout(int n) {
        this.pendingValueInt_[24] = n;
        this.userChangedAttribute_[24] = true;
        this.userCommittedChange_[24] = false;
    }

    public boolean isWINSServer() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[25] == 1;
    }

    public boolean isWINSServerPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[25] == 1;
    }

    public void setWINSServer(boolean bl) {
        this.pendingValueInt_[25] = bl ? 1 : 0;
        this.userChangedAttribute_[25] = true;
        this.userCommittedChange_[25] = false;
    }

    public String getWINSPrimaryAddress() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[7];
    }

    public String getWINSPrimaryAddressPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[7];
    }

    public void setWINSPrimaryAddress(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[7] = string.trim();
        this.userChangedAttribute_[7] = true;
        this.userCommittedChange_[7] = false;
    }

    public String getWINSScopeID() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[8];
    }

    public String getWINSScopeIDPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[8];
    }

    public void setWINSScopeID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[8] = string.trim();
        this.userChangedAttribute_[8] = true;
        this.userCommittedChange_[8] = false;
    }

    public String getWINSSecondaryAddress() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[9];
    }

    public String getWINSSecondaryAddressPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[9];
    }

    public void setWINSSecondaryAddress(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[9] = string.trim();
        this.userChangedAttribute_[9] = true;
        this.userCommittedChange_[9] = false;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieveAutostart();
        this.changedAutoStartSinceRefresh_ = false;
        this.openListOfServerInfo();
        this.refreshedSinceStart_ = true;
    }

    private void refreshWithoutException() {
        block2: {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block2;
                Trace.log(2, "Exception swallowed by refresh(): ", (Throwable)exception);
            }
        }
    }

    public void commitChanges() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change NetServer attributes.");
            throw new AS400SecurityException(40);
        }
        if (!this.refreshedSinceStart_) {
            this.refresh();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.userChangedAttribute_[0] && !this.userCommittedChange_[0]) {
            bl2 = true;
        }
        if (this.userChangedAttribute_[1] && !this.userCommittedChange_[1]) {
            bl = true;
        }
        if (this.userChangedAttribute_[2] && !this.userCommittedChange_[2]) {
            bl4 = true;
        }
        if (this.userChangedAttribute_[20] && !this.userCommittedChange_[20]) {
            bl = true;
        }
        if (this.userChangedAttribute_[21] && !this.userCommittedChange_[21]) {
            bl = true;
        }
        if (this.userChangedAttribute_[3] && !this.userCommittedChange_[3]) {
            bl2 = true;
        }
        if (this.userChangedAttribute_[4] && !this.userCommittedChange_[4]) {
            bl2 = true;
        }
        if (this.userChangedAttribute_[5] && !this.userCommittedChange_[5]) {
            bl3 = true;
        }
        if (this.userChangedAttribute_[22] && !this.userCommittedChange_[22]) {
            bl = true;
        }
        if (this.userChangedAttribute_[24] && !this.userCommittedChange_[24]) {
            bl = true;
        }
        if (this.userChangedAttribute_[23] && !this.userCommittedChange_[23]) {
            bl = true;
        }
        if (this.userChangedAttribute_[6] && !this.userCommittedChange_[6]) {
            bl2 = true;
        }
        if (this.userChangedAttribute_[25] && !this.userCommittedChange_[25]) {
            bl = true;
        }
        if (this.userChangedAttribute_[7] && !this.userCommittedChange_[7]) {
            bl = true;
        }
        if (this.userChangedAttribute_[8] && !this.userCommittedChange_[8]) {
            bl = true;
        }
        if (this.userChangedAttribute_[9] && !this.userCommittedChange_[9]) {
            bl = true;
        }
        if (this.getSystemVRM() >= 328704) {
            if (this.userChangedAttribute_[26] && !this.userCommittedChange_[26]) {
                bl = true;
            }
            if (this.userChangedAttribute_[27] && !this.userCommittedChange_[27]) {
                bl = true;
            }
            if (this.userChangedAttribute_[28] && !this.userCommittedChange_[28]) {
                bl = true;
            }
        }
        if (this.getSystemVRM() >= 459776 && this.userChangedAttribute_[29] && !this.userCommittedChange_[29]) {
            bl = true;
        }
        if (bl) {
            this.changeServerInfo();
        }
        if (bl2) {
            this.changeServerName();
        }
        if (bl3) {
            this.changeServerGuest();
        }
        if (bl4) {
            this.changeAutostart();
        }
        for (int i = 0; i < this.userCommittedChange_.length; ++i) {
            if (!this.userChangedAttribute_[i]) continue;
            this.userCommittedChange_[i] = true;
        }
    }

    private void changeAutostart() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(4, n);
        AS400Text aS400Text2 = new AS400Text(30, n);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes("*CHG")), new ProgramParameter(aS400Text2.toBytes("*NETSVR")), new ProgramParameter(aS400Text.toBytes(this.pendingValueStr_[2])), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QTOCAUTO.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        this.changedAutoStartSinceRefresh_ = true;
    }

    private void retrieveAutostart() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        String string;
        if (!this.userHasSpecialAuthority()) {
            string = "*NO";
        } else {
            int n = this.system_.getCcsid();
            CharConverter charConverter = new CharConverter(n);
            AS400Text aS400Text = new AS400Text(4, n);
            AS400Text aS400Text2 = new AS400Text(30, n);
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes("*RTV")), new ProgramParameter(aS400Text2.toBytes("*NETSVR")), new ProgramParameter(4), new ErrorCodeParameter()};
            ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QTOCAUTO.PGM", programParameterArray);
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byte[] byArray = programParameterArray[2].getOutputData();
            string = charConverter.byteArrayToString(byArray).trim();
            if (string.equals("*ERR")) {
                Trace.log(2, "The QTOCOAUTO API returned *ERR.");
                throw new InternalErrorException(6);
            }
        }
        this.effectiveValueStr_[2] = string;
        if (!this.userChangedAttribute_[2]) {
            this.pendingValueStr_[2] = string;
        }
    }

    private void changeServerGuest() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        AS400Text aS400Text = new AS400Text(10, this.system_.getCcsid());
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(aS400Text.toBytes(this.pendingValueStr_[5])), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSG.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    private void changeServerInfo() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        Serializable serializable;
        byte[] byArray;
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        AS400Text aS400Text2 = new AS400Text(224, n);
        ProgramParameter[] programParameterArray = new ProgramParameter[4];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(296);
        if (this.getSystemVRM() >= 459776) {
            byteArrayOutputStream = new ByteArrayOutputStream(300);
            if (this.getSystemVRM() >= 460032) {
                byteArrayOutputStream = new ByteArrayOutputStream(310);
            }
        }
        byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[21]));
        byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[22]));
        byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[24]));
        byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[20]));
        byteArrayOutputStream.write(aS400Text.toBytes(this.pendingValueStr_[7]));
        byteArrayOutputStream.write(aS400Text.toBytes(this.pendingValueStr_[9]));
        byteArrayOutputStream.write(aS400Text2.toBytes(this.pendingValueStr_[8]));
        if (this.pendingValueInt_[25] == 1) {
            byteArrayOutputStream.write(241);
        } else {
            byteArrayOutputStream.write(240);
        }
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0};
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[23]));
        if (this.getSystemVRM() >= 328192 && (this.getSystemVRM() >= 328704 || this.userChangedAttribute_[1])) {
            switch (this.pendingValueStr_[1].charAt(0)) {
                case '0': {
                    byteArrayOutputStream.write(240);
                    break;
                }
                case '1': {
                    byteArrayOutputStream.write(241);
                    break;
                }
                default: {
                    byteArrayOutputStream.write(242);
                }
            }
        }
        if (this.getSystemVRM() >= 328704) {
            byArray = new byte[]{0, 0, 0};
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[26]));
            byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[27]));
            byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[28]));
            if (this.getSystemVRM() >= 459776) {
                byteArrayOutputStream.write(BinaryConverter.intToByteArray(this.pendingValueInt_[29]));
                if (this.getSystemVRM() >= 460032) {
                    serializable = new AS400Text(10, n);
                    byteArrayOutputStream.write(((AS400Text)serializable).toBytes(this.pendingValueStr_[30]));
                }
            }
        }
        byteArrayOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        programParameterArray[0] = new ProgramParameter(byArray);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(byArray.length));
        programParameterArray[2] = new ProgramParameter(charConverter.stringToByteArray("ZLSS0100"));
        programParameterArray[3] = new ErrorCodeParameter();
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSI.PGM", programParameterArray);
        if (!((ProgramCall)serializable).run()) {
            throw new AS400Exception(((ProgramCall)serializable).getMessageList());
        }
    }

    private void changeServerName() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(15, n);
        AS400Text aS400Text2 = new AS400Text(50, n);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(aS400Text.toBytes(this.pendingValueStr_[6].trim()));
        programParameterArray[1] = new ProgramParameter(aS400Text.toBytes(this.pendingValueStr_[4].trim()));
        programParameterArray[2] = new ProgramParameter(aS400Text2.toBytes(this.pendingValueStr_[3].trim()));
        programParameterArray[3] = new ErrorCodeParameter();
        byte[] byArray = new byte[]{this.pendingValueStr_[0].equals("1") ? (byte)-15 : -16};
        programParameterArray[4] = new ProgramParameter(byArray);
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHSN.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    private void openListOfServerInfo() throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        int n2 = 772;
        if (this.getSystemVRM() >= 460032) {
            n2 = 800;
        } else if (this.getSystemVRM() >= 459776) {
            n2 = 780;
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0201")), new ProgramParameter(aS400Text.toBytes("*ALL")), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        this.effectiveValueInt_[21] = BinaryConverter.byteArrayToInt(byArray, 0);
        if (!this.userChangedAttribute_[21]) {
            this.pendingValueInt_[21] = BinaryConverter.byteArrayToInt(byArray, 4);
        }
        this.effectiveValueInt_[22] = BinaryConverter.byteArrayToInt(byArray, 8);
        if (!this.userChangedAttribute_[22]) {
            this.pendingValueInt_[22] = BinaryConverter.byteArrayToInt(byArray, 12);
        }
        this.effectiveValueInt_[24] = BinaryConverter.byteArrayToInt(byArray, 16);
        if (!this.userChangedAttribute_[24]) {
            this.pendingValueInt_[24] = BinaryConverter.byteArrayToInt(byArray, 20);
        }
        this.effectiveValueInt_[20] = BinaryConverter.byteArrayToInt(byArray, 24);
        if (!this.userChangedAttribute_[20]) {
            this.pendingValueInt_[20] = BinaryConverter.byteArrayToInt(byArray, 28);
        }
        this.effectiveValueInt_[25] = BinaryConverter.byteArrayToInt(byArray, 32);
        if (!this.userChangedAttribute_[25]) {
            this.pendingValueInt_[25] = BinaryConverter.byteArrayToInt(byArray, 36);
        }
        this.effectiveValueStr_[5] = charConverter.byteArrayToString(byArray, 48, 10).trim();
        if (!this.userChangedAttribute_[5]) {
            this.pendingValueStr_[5] = charConverter.byteArrayToString(byArray, 58, 10).trim();
        }
        this.effectiveValueStr_[6] = charConverter.byteArrayToString(byArray, 68, 15).trim();
        if (!this.userChangedAttribute_[6]) {
            this.pendingValueStr_[6] = charConverter.byteArrayToString(byArray, 83, 15).trim();
        }
        this.effectiveValueStr_[4] = charConverter.byteArrayToString(byArray, 98, 15).trim();
        if (!this.userChangedAttribute_[4]) {
            this.pendingValueStr_[4] = charConverter.byteArrayToString(byArray, 113, 15).trim();
        }
        this.effectiveValueStr_[3] = charConverter.byteArrayToString(byArray, 128, 50).trim();
        if (!this.userChangedAttribute_[3]) {
            this.pendingValueStr_[3] = charConverter.byteArrayToString(byArray, 178, 50).trim();
        }
        this.effectiveValueStr_[7] = charConverter.byteArrayToString(byArray, 228, 15).trim();
        if (!this.userChangedAttribute_[7]) {
            this.pendingValueStr_[7] = charConverter.byteArrayToString(byArray, 243, 15).trim();
        }
        this.effectiveValueStr_[9] = charConverter.byteArrayToString(byArray, 258, 15).trim();
        if (!this.userChangedAttribute_[9]) {
            this.pendingValueStr_[9] = charConverter.byteArrayToString(byArray, 273, 15).trim();
        }
        this.effectiveValueStr_[8] = charConverter.byteArrayToString(byArray, 288, 224).trim();
        if (!this.userChangedAttribute_[8]) {
            this.pendingValueStr_[8] = charConverter.byteArrayToString(byArray, 512, 224).trim();
        }
        this.effectiveValueStr_[0] = charConverter.byteArrayToString(byArray, 736, 1);
        if (!this.userChangedAttribute_[0]) {
            this.pendingValueStr_[0] = charConverter.byteArrayToString(byArray, 737, 1);
        }
        this.effectiveValueStr_[1] = charConverter.byteArrayToString(byArray, 738, 1);
        if (!this.userChangedAttribute_[1]) {
            this.pendingValueStr_[1] = charConverter.byteArrayToString(byArray, 739, 1);
        }
        this.effectiveValueInt_[23] = BinaryConverter.byteArrayToInt(byArray, 740);
        if (!this.userChangedAttribute_[23]) {
            this.pendingValueInt_[23] = BinaryConverter.byteArrayToInt(byArray, 744);
        }
        if (this.getSystemVRM() >= 328704) {
            this.effectiveValueInt_[26] = BinaryConverter.byteArrayToInt(byArray, 748);
            if (!this.userChangedAttribute_[26]) {
                this.pendingValueInt_[26] = BinaryConverter.byteArrayToInt(byArray, 752);
            }
            this.effectiveValueInt_[27] = BinaryConverter.byteArrayToInt(byArray, 756);
            if (!this.userChangedAttribute_[27]) {
                this.pendingValueInt_[27] = BinaryConverter.byteArrayToInt(byArray, 760);
            }
            this.effectiveValueInt_[28] = BinaryConverter.byteArrayToInt(byArray, 764);
            if (!this.userChangedAttribute_[28]) {
                this.pendingValueInt_[28] = BinaryConverter.byteArrayToInt(byArray, 768);
            }
            if (this.getSystemVRM() >= 459776) {
                this.effectiveValueInt_[29] = BinaryConverter.byteArrayToInt(byArray, 772);
                if (!this.userChangedAttribute_[29]) {
                    this.pendingValueInt_[29] = BinaryConverter.byteArrayToInt(byArray, 776);
                }
                if (this.getSystemVRM() >= 460032) {
                    this.effectiveValueStr_[30] = charConverter.byteArrayToString(byArray, 780, 10);
                    if (!this.userChangedAttribute_[30]) {
                        this.pendingValueStr_[30] = charConverter.byteArrayToString(byArray, 790, 10);
                    }
                }
            }
        }
    }

    private boolean userHasSpecialAuthority() {
        if (!this.determinedSpecialAuthority_) {
            boolean bl = false;
            try {
                User user = new User(this.system_, this.system_.getUserId());
                bl = user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION);
            }
            catch (Exception exception) {
                Trace.log(2, exception);
            }
            if (!bl) {
                Trace.log(4, "User " + this.system_.getUserId() + " does not have *IOSYSCFG authority.");
            }
            this.userHasSpecialAuthority_ = bl;
            this.determinedSpecialAuthority_ = true;
        }
        return this.userHasSpecialAuthority_;
    }

    public void end() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to end the NetServer process.");
            throw new AS400SecurityException(40);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSENDS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public void endSession(long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.endSessions(null, l);
    }

    public void endSessionsForWorkstation(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.endSessions(string, 0L);
    }

    private void endSessions(String string, long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to end a NetServer session.");
            throw new AS400SecurityException(40);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[3];
        AS400Text aS400Text = new AS400Text(15, this.system_.getCcsid());
        AS400Text aS400Text2 = new AS400Text(50, this.system_.getCcsid());
        if (string == null) {
            programParameterArray[0] = new ProgramParameter(aS400Text.toBytes("*SESSID"));
            programParameterArray[2] = new ProgramParameter(BinaryConverter.longToByteArray(l));
        } else if (this.getSystemVRM() < 393472) {
            programParameterArray[0] = new ProgramParameter(aS400Text.toBytes(string));
            programParameterArray[2] = new ProgramParameter(BinaryConverter.longToByteArray(0L));
        } else {
            programParameterArray[0] = new ProgramParameter(aS400Text.toBytes("*EXPANDED"));
            programParameterArray[2] = new ProgramParameter(aS400Text2.toBytes(string));
        }
        programParameterArray[1] = new ErrorCodeParameter();
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSENSS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public boolean isStarted() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        JobList jobList = new JobList(this.getSystem());
        try {
            jobList.addJobSelectionCriteria(1, "QZLSSERVER");
            jobList.addJobSelectionCriteria(5, Boolean.TRUE);
            jobList.addJobSelectionCriteria(6, Boolean.FALSE);
            jobList.addJobSelectionCriteria(7, Boolean.FALSE);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
        }
        jobList.load();
        boolean bl = jobList.getLength() != 0;
        jobList.close();
        return bl;
    }

    private boolean isQserverStarted() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        JobList jobList = new JobList(this.getSystem());
        try {
            jobList.addJobSelectionCriteria(1, "QSERVER");
            jobList.addJobSelectionCriteria(2, "QSYS");
            jobList.addJobSelectionCriteria(5, Boolean.TRUE);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
        }
        jobList.load();
        boolean bl = jobList.getLength() != 0;
        jobList.close();
        return bl;
    }

    public void start() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.start(false);
    }

    public void start(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to start the NetServer process.");
            throw new AS400SecurityException(40);
        }
        if (this.isStarted()) {
            return;
        }
        if (!this.isQserverStarted() && !((CommandCall)(object = new CommandCall(this.getSystem(), "STRSBS SBSD(QSERVER)"))).run()) {
            Trace.log(2, "Error when starting QSERVER subsystem.");
            throw new AS400Exception(((CommandCall)object).getMessageList());
        }
        this.refreshedSinceStart_ = false;
        object = new ProgramParameter[2];
        byte[] byArray = new byte[]{bl ? (byte)-15 : -16};
        object[0] = new ProgramParameter(byArray);
        object[1] = new ErrorCodeParameter();
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSSTRS.PGM", (ProgramParameter[])object);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    public void refresh(ISeriesNetServerConnection iSeriesNetServerConnection) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Serializable serializable;
        boolean bl;
        String string;
        if (iSeriesNetServerConnection == null) {
            throw new NullPointerException();
        }
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(15, n);
        int n2 = 64;
        int n3 = this.getSystemVRM();
        if (iSeriesNetServerConnection.getResourceType() == 0) {
            string = "ZLSL0600";
            bl = true;
        } else {
            string = "ZLSL0700";
            bl = false;
            if (n3 >= 393472) {
                n2 = 192;
            }
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[bl && n3 >= 393472 ? 8 : 6];
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[2] = new ProgramParameter(64);
        programParameterArray[3] = new ProgramParameter(charConverter.stringToByteArray(string));
        if (bl && n3 >= 393472) {
            serializable = new AS400Text(10, n);
            AS400Text aS400Text2 = new AS400Text(50, n);
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes("*EXPANDED"));
            programParameterArray[6] = new ProgramParameter(((AS400Text)serializable).toBytes("*ALL"));
            programParameterArray[7] = new ProgramParameter(aS400Text2.toBytes(iSeriesNetServerConnection.getName()));
        } else {
            programParameterArray[4] = new ProgramParameter(aS400Text.toBytes(iSeriesNetServerConnection.getName()));
        }
        programParameterArray[5] = new ErrorCodeParameter();
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n4 = ISeriesNetServer.callListProgram((ProgramCall)serializable, programParameterArray, n2);
        if (n4 == 0) {
            Trace.log(2, "refresh() failed: Connection not found.");
        } else if (n4 > 1) {
            Trace.log(2, "refresh() failed: More than one connection returned from QZLSOLST.");
        } else {
            byte[] byArray = programParameterArray[0].getOutputData();
            this.parseZLSL0600or0700(byArray, 0, charConverter, bl, iSeriesNetServerConnection);
        }
    }

    public void refresh(ISeriesNetServerSession iSeriesNetServerSession) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (iSeriesNetServerSession == null) {
            throw new NullPointerException();
        }
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        AS400Text aS400Text = new AS400Text(10, n);
        AS400Text aS400Text2 = new AS400Text(15, n);
        int n2 = this.getSystemVRM() < 393472 ? 64 : 113;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0300")), new ProgramParameter(aS400Text2.toBytes("*SESSID")), new ErrorCodeParameter(), new ProgramParameter(aS400Text.toBytes("*SESSID")), new ProgramParameter(BinaryConverter.longToByteArray(iSeriesNetServerSession.getID()))};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray);
        int n3 = ISeriesNetServer.callListProgram(programCall, programParameterArray, n2);
        if (n3 == 0) {
            Trace.log(2, "refresh() failed: Session not found.");
        } else if (n3 > 1) {
            Trace.log(2, "refresh() failed: More than one session returned from QZLSOLST.");
        } else {
            byte[] byArray = programParameterArray[0].getOutputData();
            this.parseZLSL0300(byArray, 0, charConverter, iSeriesNetServerSession);
        }
    }

    public void refresh(ISeriesNetServerShare iSeriesNetServerShare) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] programParameterArray;
        ProgramCall programCall;
        int n;
        if (iSeriesNetServerShare == null) {
            throw new NullPointerException();
        }
        int n2 = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n2);
        AS400Text aS400Text = new AS400Text(15, n2);
        if (this.getSystemVRM() >= 459776) {
            IBMi74 = true;
        }
        if (this.getSystemVRM() >= 460032) {
            IBMi75 = true;
        }
        int n3 = 1221;
        if (IBMi74) {
            n3 = 1223;
            if (IBMi75) {
                n3 = 1233;
            }
        }
        if ((n = ISeriesNetServer.callListProgram(programCall = new ProgramCall(this.system_, "/QSYS.LIB/QZLSOLST.PGM", programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(64), new ProgramParameter(charConverter.stringToByteArray("ZLSL0101")), new ProgramParameter(aS400Text.toBytes(iSeriesNetServerShare.getName().trim())), new ErrorCodeParameter()}), programParameterArray, n3)) == 0) {
            Trace.log(2, "refresh() failed: Share not found.");
        } else if (n > 1) {
            Trace.log(2, "refresh() failed: More than one share returned from QZLSOLST.");
        } else {
            byte[] byArray = programParameterArray[0].getOutputData();
            int n4 = iSeriesNetServerShare.isFile_ ? 0 : 1;
            ISeriesNetServer.parseZLSL0101(byArray, charConverter, 1, n4, iSeriesNetServerShare);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing ISeriesNetServer object.");
        }
        objectInputStream.defaultReadObject();
        this.refreshedSinceStart_ = false;
        this.determinedSpecialAuthority_ = false;
        this.userHasSpecialAuthority_ = false;
    }

    public String toString() {
        String string = this.refreshedSinceStart_ ? this.effectiveValueStr_[6] : "unknown";
        return "ISeriesNetServer (system: " + this.system_.getSystemName() + "; name: " + string + "): " + super.toString();
    }

    public void commitChanges(ISeriesNetServerFileShare iSeriesNetServerFileShare) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        Object object2;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change share attributes.");
            throw new AS400SecurityException(40);
        }
        int n = iSeriesNetServerFileShare.numOptionalParmsToSet_;
        int n2 = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n2);
        AS400Text aS400Text = new AS400Text(12, n2);
        AS400Text aS400Text2 = new AS400Text(50, n2);
        ProgramParameter[] programParameterArray = new ProgramParameter[8 + n];
        programParameterArray[0] = new ProgramParameter(aS400Text.toBytes(iSeriesNetServerFileShare.name_));
        byte[] byArray = charConverter.stringToByteArray(iSeriesNetServerFileShare.path_);
        programParameterArray[1] = new ProgramParameter(byArray);
        programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(byArray.length));
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[4] = new ProgramParameter(aS400Text2.toBytes(iSeriesNetServerFileShare.description_));
        programParameterArray[5] = new ProgramParameter(BinaryConverter.intToByteArray(iSeriesNetServerFileShare.permissions_));
        programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(iSeriesNetServerFileShare.maxNumberOfUsers_));
        programParameterArray[7] = new ErrorCodeParameter();
        if (n >= 1) {
            programParameterArray[8] = new ProgramParameter(BinaryConverter.intToByteArray(iSeriesNetServerFileShare.ccsidForTextConversion_));
        }
        if (n >= 2) {
            object2 = new byte[]{iSeriesNetServerFileShare.textConversionEnablement_.equals("0") ? (byte)-16 : (iSeriesNetServerFileShare.textConversionEnablement_.equals("1") ? (byte)-15 : -14)};
            programParameterArray[9] = new ProgramParameter((byte[])object2);
        }
        if (n >= 4) {
            int n3 = iSeriesNetServerFileShare.fileExtensions_.length;
            if (n3 == 0) {
                programParameterArray[10] = new ProgramParameter(charConverter.stringToByteArray(""));
            } else {
                object = new ByteArrayOutputStream(n3 * 50);
                for (int i = 0; i < n3; ++i) {
                    int n4 = iSeriesNetServerFileShare.fileExtensions_[i].length();
                    ((OutputStream)object).write(BinaryConverter.intToByteArray(n4));
                    ((OutputStream)object).write(charConverter.stringToByteArray(iSeriesNetServerFileShare.fileExtensions_[i]));
                    int n5 = 50 - (4 + n4);
                    for (int j = 0; j < n5; ++j) {
                        ((ByteArrayOutputStream)object).write(0);
                    }
                }
                ((OutputStream)object).flush();
                byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                programParameterArray[10] = new ProgramParameter(byArray2);
            }
            programParameterArray[11] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        }
        if (this.getSystemVRM() >= 459776 && n >= 5) {
            object2 = new byte[1];
            if (iSeriesNetServerFileShare.encryptionRequired_.equals("0")) {
                object2[0] = -16;
            } else if (iSeriesNetServerFileShare.encryptionRequired_.equals("1")) {
                object2[0] = -15;
            }
            programParameterArray[12] = new ProgramParameter((byte[])object2);
        }
        object2 = new AS400Text(10, n2);
        if (this.getSystemVRM() >= 460032 && n >= 6) {
            object = "*SAME";
            if (iSeriesNetServerFileShare.authorizationList_ != null) {
                object = iSeriesNetServerFileShare.authorizationList_;
            }
            programParameterArray[13] = new ProgramParameter(object2.toBytes(object));
        }
        if (!((ProgramCall)(object = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHFS.PGM", programParameterArray))).run()) {
            throw new AS400Exception(((ProgramCall)object).getMessageList());
        }
        iSeriesNetServerFileShare.numOptionalParmsToSet_ = 0;
    }

    public void commitChanges(ISeriesNetServerPrintShare iSeriesNetServerPrintShare) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        Object object2;
        if (!this.userHasSpecialAuthority()) {
            Trace.log(2, "*IOSYSCFG authority is required in order to change share attributes.");
            throw new AS400SecurityException(40);
        }
        int n = iSeriesNetServerPrintShare.numOptionalParmsToSet_;
        int n2 = this.system_.getCcsid();
        AS400Text aS400Text = new AS400Text(12, n2);
        AS400Text aS400Text2 = new AS400Text(20, n2);
        AS400Text aS400Text3 = new AS400Text(50, n2);
        ProgramParameter[] programParameterArray = new ProgramParameter[6 + n];
        programParameterArray[0] = new ProgramParameter(aS400Text.toBytes(iSeriesNetServerPrintShare.name_));
        programParameterArray[1] = new ProgramParameter(aS400Text2.toBytes(iSeriesNetServerPrintShare.outputQueue_));
        programParameterArray[2] = new ProgramParameter(aS400Text3.toBytes(iSeriesNetServerPrintShare.description_));
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(iSeriesNetServerPrintShare.spooledFileType_));
        programParameterArray[4] = new ProgramParameter(aS400Text3.toBytes(iSeriesNetServerPrintShare.printDriver_));
        programParameterArray[5] = new ErrorCodeParameter();
        if (n >= 1) {
            programParameterArray[6] = new ProgramParameter(aS400Text2.toBytes(iSeriesNetServerPrintShare.printerFile_));
        }
        if (n >= 2) {
            object2 = new byte[]{iSeriesNetServerPrintShare.isPublished_ ? (byte)-15 : -16};
            programParameterArray[7] = new ProgramParameter((byte[])object2);
        }
        if (this.getSystemVRM() >= 459776 && n >= 3) {
            object2 = new byte[1];
            if (iSeriesNetServerPrintShare.encryptionRequired_.equals("0")) {
                object2[0] = -16;
            } else if (iSeriesNetServerPrintShare.encryptionRequired_.equals("1")) {
                object2[0] = -15;
            }
            programParameterArray[8] = new ProgramParameter((byte[])object2);
        }
        object2 = new AS400Text(10, n2);
        if (this.getSystemVRM() >= 460032 && n >= 4) {
            object = "*SAME";
            if (iSeriesNetServerPrintShare.authorizationList_ != null) {
                object = iSeriesNetServerPrintShare.authorizationList_;
            }
            programParameterArray[9] = new ProgramParameter(object2.toBytes(object));
        }
        if (!((ProgramCall)(object = new ProgramCall(this.system_, "/QSYS.LIB/QZLSCHPS.PGM", programParameterArray))).run()) {
            throw new AS400Exception(((ProgramCall)object).getMessageList());
        }
        iSeriesNetServerPrintShare.numOptionalParmsToSet_ = 0;
    }

    public int getEncryptedConnectionEnforcement() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueInt_[29];
    }

    public int getEncryptedConnectionEnforcementPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueInt_[29];
    }

    public void setEncryptedConnectionEnforcement(int n) {
        this.pendingValueInt_[29] = n;
        this.userChangedAttribute_[29] = true;
        this.userCommittedChange_[29] = false;
    }

    public String getServerAuthorizationList() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.effectiveValueStr_[30];
    }

    public String getServerAuthorizationListPending() {
        if (!this.refreshedSinceStart_) {
            this.refreshWithoutException();
        }
        return this.pendingValueStr_[30];
    }

    public void setServerAuthorizationList(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pendingValueStr_[30] = string.trim();
        this.userChangedAttribute_[30] = true;
        this.userCommittedChange_[30] = false;
    }
}

