/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.NPCPSelOutQ;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class OutputQueueList
extends PrintObjectList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String QUEUE_FILTER = "queueFilter";

    public OutputQueueList() {
        super(4, new NPCPSelOutQ());
    }

    public OutputQueueList(AS400 aS400) {
        super(4, new NPCPSelOutQ(), aS400);
    }

    void chooseImpl() {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use OutputQueueList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)aS400.loadImpl2("com.ibm.as400.access.OutputQueueListImplRemote", "com.ibm.as400.access.OutputQueueListImplProxy");
        super.setImpl();
    }

    public String getQueueFilter() {
        NPCPSelOutQ nPCPSelOutQ = (NPCPSelOutQ)this.getSelectionCP();
        return nPCPSelOutQ.getQueue();
    }

    PrintObject newNPObject(NPCPID nPCPID, NPCPAttribute nPCPAttribute) {
        return new OutputQueue(this.system_, (NPCPIDOutQ)nPCPID, nPCPAttribute);
    }

    public void setQueueFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'queue' is null");
            throw new NullPointerException(QUEUE_FILTER);
        }
        String string2 = this.getQueueFilter();
        this.vetos.fireVetoableChange(QUEUE_FILTER, string2, string);
        NPCPSelOutQ nPCPSelOutQ = (NPCPSelOutQ)this.getSelectionCP();
        nPCPSelOutQ.setQueue(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("queue", string);
        }
        this.changes.firePropertyChange(QUEUE_FILTER, string2, string);
    }
}

