/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class SecureAS400
extends AS400 {
    static final long serialVersionUID = 4L;
    public static final int CLIENT_TO_PROXY_SERVER = 1;
    public static final int PROXY_SERVER_TO_SERVER = 2;
    public static final int CLINT_TO_SERVER = 3;
    public static final int CLIENT_TO_SERVER = 3;
    public static boolean changeCipherSuites = false;
    public static String[] newCipherSuites;

    private void construct() {
        if (Trace.traceOn_) {
            Trace.log(1, "Turning SSL connections on.");
        }
        this.useSSLConnection_ = new SSLOptions();
        String string = SystemProperties.getProperty("com.ibm.as400.access.SecureAS400.proxyEncryptionMode");
        if (string != null && (string.equals("1") || string.equals("2"))) {
            this.useSSLConnection_.proxyEncryptionMode_ = Integer.parseInt(string);
        }
    }

    public SecureAS400() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string) {
        super(string);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, String string2) {
        super(string, string2);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, ProfileTokenCredential profileTokenCredential) {
        super(string, profileTokenCredential);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, String string2, String string3) {
        super(string, string2, string3);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, String string2, char[] cArray) {
        super(string, string2, cArray);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String string, String string2, char[] cArray, String string3) {
        super(string, string2, cArray, string3);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(AS400 aS400) {
        super(aS400);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
        if (aS400.useSSLConnection_ != null) {
            this.useSSLConnection_.proxyEncryptionMode_ = aS400.useSSLConnection_.proxyEncryptionMode_;
        }
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        AS400.addPasswordCacheEntry(new SecureAS400(string, string2, string3));
    }

    public static void addPasswordCacheEntry(String string, String string2, char[] cArray) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        AS400.addPasswordCacheEntry(new SecureAS400(string, string2, cArray));
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3, String string4) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string4 + "'");
        }
        AS400.addPasswordCacheEntry(new SecureAS400(string, string2, string3, string4));
    }

    public static void addPasswordCacheEntry(String string, String string2, char[] cArray, String string3) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string3 + "'");
        }
        AS400.addPasswordCacheEntry(new SecureAS400(string, string2, cArray, string3));
    }

    public String getKeyRingName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key ring name: null");
        }
        return null;
    }

    public int getProxyEncryptionMode() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting proxy encryption mode:", this.useSSLConnection_.proxyEncryptionMode_);
        }
        return this.useSSLConnection_.proxyEncryptionMode_;
    }

    public void setKeyRingName(String string) throws PropertyVetoException {
        Trace.log(2, "Cannot set key ring class name  -- no sslight support ");
        throw new ExtendedIllegalStateException("keyRingName", 11);
    }

    public void setKeyRingName(String string, String string2) throws PropertyVetoException {
        Trace.log(2, "Cannot set key ring class name  -- no sslight support ");
        throw new ExtendedIllegalStateException("keyRingName", 11);
    }

    public void setKeyRingPassword(String string) {
        Trace.log(2, "Cannot set key ring class password.");
        throw new ExtendedIllegalStateException("keyRingPassword", 5);
    }

    public void setProxyEncryptionMode(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting proxy encryption mode:", n);
        }
        if (n < 1 || n > 3) {
            Trace.log(2, "Value of parameter 'proxyEncryptionMode' is not valid:", n);
            throw new ExtendedIllegalArgumentException("proxyEncryptionMode (" + n + ")", 2);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set proxy encryption mode after connection has been made.");
            throw new ExtendedIllegalStateException("proxyEncryptionMode", 5);
        }
        Integer n2 = new Integer(this.useSSLConnection_.proxyEncryptionMode_);
        Integer n3 = new Integer(n);
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("proxyEncryptionMode", n2, n3);
        }
        this.useSSLConnection_.proxyEncryptionMode_ = n;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("proxyEncryptionMode", n2, n3);
        }
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            changeCipherSuites = true;
            newCipherSuites = stringArray;
        }
    }
}

