/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.SubstringValueMap;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;
import java.io.UnsupportedEncodingException;

public class RMessageQueue
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "MESSAGE_QUEUE";
    private static final String ICON_BASE_NAME_ = "RMessageQueue";
    private static PresentationLoader presentationLoader_;
    public static final String ALL = "*ALL";
    public static final String ANY = "*ANY";
    public static final String BYKEY = "*BYKEY";
    public static final String COMPLETION = "*COMP";
    public static final String COPY = "*COPY";
    public static final String CURRENT = "*CURRENT";
    public static final String DIAGNOSTIC = "*DIAG";
    public static final String FIRST = "*FIRST";
    public static final String INFORMATIONAL = "*INFO";
    public static final String INQUIRY = "*INQ";
    public static final String KEEP_UNANSWERED = "*KEEPUNANS";
    public static final String LAST = "*LAST";
    public static final String MESSAGES_NEED_REPLY = "*MNR";
    public static final String MESSAGES_NO_NEED_REPLY = "*MNNR";
    public static final String NEW = "*NEW";
    public static final byte[] NEWEST;
    public static final String NEXT = "*NEXT";
    public static final String OLD = "*OLD";
    public static final byte[] OLDEST;
    public static final String PREVIOUS = "*PRV";
    public static final String REMOVE = "*REMOVE";
    public static final String REPLY = "*RPY";
    public static final String SAME = "*SAME";
    public static final String SENDERS_COPY_NEED_REPLY = "*SCNR";
    public static final Integer NO_FORMATTING;
    public static final Integer RETURN_FORMATTING_CHARACTERS;
    public static final Integer SUBSTITUTE_FORMATTING_CHARACTERS;
    private static ResourceMetaDataTable selections_;
    private static ProgramMap selectionMap_;
    public static final String FORMATTING_CHARACTERS = "FORMATTING_CHARACTERS";
    public static final String LIST_DIRECTION = "LIST_DIRECTION";
    public static final String REPLACEMENT_DATA = "REPLACEMENT_DATA";
    public static final String SELECTION_CRITERIA = "SELECTION_CRITERIA";
    public static final String SEVERITY_CRITERIA = "SEVERITY_CRITERIA";
    public static final String SORT_CRITERIA = "SORT_CRITERIA";
    public static final String STARTING_USER_MESSAGE_KEY = "STARTING_USER_MESSAGE_KEY";
    public static final String STARTING_WORKSTATION_MESSAGE_KEY = "STARTING_WORKSTATION_MESSAGE_KEY";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyolmsg";
    private static final String receiveProgramName_ = "qmhrcvm";
    private static ProgramMap receiveAttributeMap_;
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RMessageQueue";
    private static final String messageFieldIdentifier_ = "qgyolmsg.messageSelectionInformation.messageFieldIdentifier";
    private static final String messageHelpFieldIdentifier_ = "qgyolmsg.messageSelectionInformation.messageHelpFieldIdentifier";
    private static ProgramCallDocument staticDocument_;
    private static final byte[] BLANK_KEY;
    private static final String QUSRSYS = "QUSRSYS";
    private ProgramCallDocument document_ = null;
    private String path_ = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;

    public RMessageQueue() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RQueuedMessage.attributes_, selections_, null, openListProgramName_, null, selectionMap_);
        try {
            this.setPath(CURRENT);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RMessageQueue(AS400 aS400) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RMessageQueue(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
            this.setPath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void establishConnection() throws ResourceException {
        block3: {
            if (this.path_ == null) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            super.establishConnection();
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
            this.setDocument(this.document_);
            try {
                this.document_.setValue("qgyolmsg.userOrQueueInformation.userOrQueueIndicator", this.path_.equals(CURRENT) ? "0" : "1");
                this.formatQualifiedMessageQueueName(this.document_, "qgyolmsg.userOrQueueInformation.userOrQueueName");
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(2, "Error setting path information in PCML document", (Throwable)pcmlException);
            }
        }
    }

    private void formatQualifiedMessageQueueName(ProgramCallDocument programCallDocument, String string) throws PcmlException {
        if (this.path_.equals(CURRENT)) {
            AS400 aS400 = this.getSystem();
            if (aS400 != null) {
                String string2 = aS400.getUserId();
                programCallDocument.setValue(string + ".objectName", string2);
                programCallDocument.setValue(string + ".libraryName", QUSRSYS);
            }
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
            programCallDocument.setValue(string + ".objectName", qSYSObjectPathName.getObjectName());
            programCallDocument.setValue(string + ".libraryName", qSYSObjectPathName.getLibraryName());
        }
    }

    public String getPath() {
        return this.path_;
    }

    public RQueuedMessage receive(byte[] byArray) throws ResourceException {
        return this.receive(byArray, 0, REMOVE, ANY);
    }

    public RQueuedMessage receive(byte[] byArray, int n, String string, String string2) throws ResourceException {
        if (string == null) {
            throw new NullPointerException("messageAction");
        }
        if (!(string.equals(OLD) || string.equals(REMOVE) || string.equals(SAME))) {
            throw new ExtendedIllegalArgumentException("messageAction", 2);
        }
        if (string2 == null) {
            throw new NullPointerException("messageType");
        }
        if (!(string2.equals(ANY) || string2.equals(COMPLETION) || string2.equals(COPY) || string2.equals(DIAGNOSTIC) || string2.equals(FIRST) || string2.equals(INFORMATIONAL) || string2.equals(INQUIRY) || string2.equals(LAST) || string2.equals(NEXT) || string2.equals(PREVIOUS) || string2.equals(REPLY))) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if ((string2.equals(COPY) || string2.equals(NEXT) || string2.equals(PREVIOUS)) && byArray == null) {
            throw new ExtendedIllegalArgumentException("messageKey", 2);
        }
        if ((string2.equals(FIRST) || string2.equals(LAST)) && byArray != null) {
            throw new ExtendedIllegalArgumentException("messageKey", 2);
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            Object object;
            this.formatQualifiedMessageQueueName(this.document_, "qmhrcvm.qualifiedMessageQueueName");
            this.document_.setValue("qmhrcvm.messageType", string2);
            this.document_.setValue("qmhrcvm.messageKey", byArray == null ? BLANK_KEY : byArray);
            this.document_.setIntValue("qmhrcvm.waitTime", n);
            this.document_.setValue("qmhrcvm.messageAction", string);
            if (!this.document_.callProgram(receiveProgramName_)) {
                throw new ResourceException(this.document_.getMessageList(receiveProgramName_));
            }
            if (this.document_.getIntValue("qmhrcvm.messageInformation.bytesReturned") <= 8) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Queued message can not be received.");
                }
                return null;
            }
            AS400 aS400 = this.getSystem();
            RQueuedMessage rQueuedMessage = new RQueuedMessage();
            try {
                rQueuedMessage.setSystem(aS400);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            Object[] objectArray = receiveAttributeMap_.getIDs();
            Object[] objectArray2 = receiveAttributeMap_.getValues(objectArray, aS400, this.document_, receiveProgramName_, null);
            for (int i = 0; i < objectArray2.length; ++i) {
                rQueuedMessage.initializeAttributeValue(objectArray[i], objectArray2[i]);
            }
            String string3 = (String)this.document_.getValue("qmhrcvm.messageInformation.message");
            byte[] byArray2 = (byte[])this.document_.getValue("qmhrcvm.messageInformation.replacementDataOrImpromptuText");
            if (((String)rQueuedMessage.getAttributeValue("MESSAGE_ID")).length() > 0) {
                rQueuedMessage.initializeAttributeValue("MESSAGE_TEXT", string3);
                rQueuedMessage.initializeAttributeValue("SUBSTITUTION_DATA", byArray2);
            } else {
                object = new CharConverter(aS400.getCcsid(), aS400);
                rQueuedMessage.initializeAttributeValue("MESSAGE_TEXT", ((CharConverter)object).byteArrayToString(byArray2));
                rQueuedMessage.initializeAttributeValue("SUBSTITUTION_DATA", byArray2);
            }
            object = RQueuedMessage.computeResourceKey(aS400, this.path_, (byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY"));
            rQueuedMessage.setResourceKey(object);
            return rQueuedMessage;
        }
        catch (PcmlException pcmlException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when receiving message", (Throwable)pcmlException);
            }
            throw new ResourceException(pcmlException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when receiving message", (Throwable)unsupportedEncodingException);
            }
            throw new ResourceException(unsupportedEncodingException);
        }
    }

    public void remove() throws ResourceException {
        this.remove(BLANK_KEY, ALL);
    }

    public void remove(byte[] byArray) throws ResourceException {
        this.remove(byArray, BYKEY);
    }

    public void remove(String string) throws ResourceException {
        this.remove(BLANK_KEY, string);
    }

    void remove(byte[] byArray, String string) throws ResourceException {
        if (byArray == null) {
            throw new NullPointerException("messageKey");
        }
        if (string == null) {
            throw new NullPointerException("messageType");
        }
        if (!(string.equals(ALL) || string.equals(BYKEY) || string.equals(KEEP_UNANSWERED) || string.equals(NEW) || string.equals(OLD))) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            this.formatQualifiedMessageQueueName(this.document_, "qmhrmvm.qualifiedMessageQueueName");
            this.document_.setValue("qmhrmvm.messageKey", byArray);
            this.document_.setValue("qmhrmvm.messagesToRemove", string);
            if (!this.document_.callProgram("qmhrmvm")) {
                throw new ResourceException(this.document_.getMessageList("qmhrmvm"));
            }
        }
        catch (PcmlException pcmlException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when removing message", (Throwable)pcmlException);
            }
            throw new ResourceException(pcmlException);
        }
    }

    public void reply(byte[] byArray, String string) throws ResourceException {
        this.reply(byArray, string, true);
    }

    public void reply(byte[] byArray, String string, boolean bl) throws ResourceException {
        if (byArray == null) {
            throw new NullPointerException("messageKey");
        }
        if (string == null) {
            throw new NullPointerException("replyText");
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            this.document_.setValue("qmhsndrm.messageKey", byArray);
            this.formatQualifiedMessageQueueName(this.document_, "qmhsndrm.qualifiedMessageQueueName");
            byte[] byArray2 = CharConverter.stringToByteArray(this.getSystem(), string);
            this.document_.setIntValue("qmhsndrm.lengthOfReplyText", byArray2.length);
            this.document_.setValue("qmhsndrm.replyText", byArray2);
            this.document_.setValue("qmhsndrm.removeMessage", bl ? "*YES" : "*NO");
            if (!this.document_.callProgram("qmhsndrm")) {
                throw new ResourceException(this.document_.getMessageList("qmhsndrm"));
            }
        }
        catch (PcmlException pcmlException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when replying to message", (Throwable)pcmlException);
            }
            throw new ResourceException(pcmlException);
        }
    }

    private byte[] send(String string, String string2, Object object, String string3, String string4) throws ResourceException {
        if (string == null) {
            throw new NullPointerException("messageID");
        }
        if (string2 == null) {
            throw new NullPointerException("messageFile");
        }
        if (object != null && !(object instanceof byte[]) && !(object instanceof String)) {
            throw new ExtendedIllegalArgumentException("substitutionData", 2);
        }
        if (string3 == null) {
            throw new NullPointerException("messageType");
        }
        if (!string3.equals(INFORMATIONAL) && !string3.equals(INQUIRY)) {
            throw new ExtendedIllegalArgumentException("messageType", 2);
        }
        if (string4 == null) {
            throw new NullPointerException("replyQueue");
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            Object object2;
            String string5;
            if (object != null) {
                if (object instanceof byte[]) {
                    string5 = "qmhsndmWithMessageData";
                    this.document_.setIntValue(string5 + ".lengthOfMessageData", ((byte[])object).length);
                    this.document_.setValue(string5 + ".messageData", object);
                } else {
                    string5 = "qmhsndmWithImmediateText";
                    object2 = CharConverter.stringToByteArray(this.getSystem(), (String)object);
                    this.document_.setIntValue(string5 + ".lengthOfImmediateText", ((byte[])object2).length);
                    this.document_.setValue(string5 + ".immediateText", object2);
                }
            } else {
                string5 = "qmhsndmWithImmediateText";
                this.document_.setIntValue(string5 + ".lengthOfImmediateText", 0);
                this.document_.setValue(string5 + ".immediateText", new byte[0]);
            }
            this.document_.setValue(string5 + ".messageID", string);
            if (string2.length() > 0) {
                object2 = new QSYSObjectPathName(string2);
                this.document_.setValue(string5 + ".qualifiedMessageFileName.objectName", object2.getObjectName());
                this.document_.setValue(string5 + ".qualifiedMessageFileName.libraryName", object2.getLibraryName());
            } else {
                this.document_.setValue(string5 + ".qualifiedMessageFileName.objectName", "");
                this.document_.setValue(string5 + ".qualifiedMessageFileName.libraryName", "");
            }
            this.document_.setValue(string5 + ".messageType", string3);
            this.formatQualifiedMessageQueueName(this.document_, string5 + ".qualifiedMessageQueueNames");
            if (string4.length() > 0) {
                object2 = new QSYSObjectPathName(string4);
                this.document_.setValue(string5 + ".qualifiedReplyMessageQueueName.objectName", object2.getObjectName());
                this.document_.setValue(string5 + ".qualifiedReplyMessageQueueName.libraryName", object2.getLibraryName());
            } else {
                this.document_.setValue(string5 + ".qualifiedReplyMessageQueueName.objectName", "");
                this.document_.setValue(string5 + ".qualifiedReplyMessageQueueName.libraryName", "");
            }
            if (!this.document_.callProgram(string5)) {
                throw new ResourceException(this.document_.getMessageList(string5));
            }
            object2 = null;
            if (string3.equals(INQUIRY)) {
                object2 = (byte[])this.document_.getValue(string5 + ".messageKey");
            }
            return object2;
        }
        catch (PcmlException pcmlException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when sending a message", (Throwable)pcmlException);
            }
            throw new ResourceException(pcmlException);
        }
    }

    public void sendInformational(String string, String string2) throws ResourceException {
        this.send(string, string2, null, INFORMATIONAL, "");
    }

    public void sendInformational(String string, String string2, byte[] byArray) throws ResourceException {
        this.send(string, string2, byArray, INFORMATIONAL, "");
    }

    public void sendInformational(String string) throws ResourceException {
        if (string == null) {
            throw new NullPointerException("messageText");
        }
        this.send("", "", string, INFORMATIONAL, "");
    }

    public byte[] sendInquiry(String string, String string2, String string3) throws ResourceException {
        return this.send(string, string2, null, INQUIRY, string3);
    }

    public byte[] sendInquiry(String string, String string2, byte[] byArray, String string3) throws ResourceException {
        return this.send(string, string2, byArray, INQUIRY, string3);
    }

    public byte[] sendInquiry(String string, String string2) throws ResourceException {
        if (string == null) {
            throw new NullPointerException("messageText");
        }
        return this.send("", "", string, INQUIRY, string2);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.path_;
        this.fireVetoableChange("path", string2, string);
        this.path_ = string.trim();
        Presentation presentation = this.getPresentation();
        if (this.path_.equals(CURRENT)) {
            presentation.setName(CURRENT);
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
            presentation.setName(qSYSObjectPathName.getObjectName());
            presentation.setFullName(qSYSObjectPathName.getPath());
        }
        this.firePropertyChange("path", string2, string);
    }

    void setOpenParameters(ProgramCallDocument programCallDocument) throws PcmlException, ResourceException {
        super.setOpenParameters(programCallDocument);
        boolean bl = (Boolean)this.getSelectionValue(REPLACEMENT_DATA);
        Integer n = (Integer)this.getSelectionValue(FORMATTING_CHARACTERS);
        if (bl) {
            programCallDocument.setIntValue(messageFieldIdentifier_, 302);
            if (n.equals(NO_FORMATTING)) {
                programCallDocument.setIntValue(messageHelpFieldIdentifier_, 402);
            } else {
                programCallDocument.setIntValue(messageHelpFieldIdentifier_, 404);
            }
        } else {
            programCallDocument.setIntValue(messageFieldIdentifier_, 301);
            if (n.equals(NO_FORMATTING)) {
                programCallDocument.setIntValue(messageHelpFieldIdentifier_, 401);
            } else {
                programCallDocument.setIntValue(messageHelpFieldIdentifier_, 403);
            }
        }
    }

    Resource newResource(String string, int[] nArray) throws PcmlException, ResourceException {
        CharSequence charSequence;
        AS400 aS400 = this.getSystem();
        byte[] byArray = (byte[])this.document_.getValue(string + ".receiverVariable.messageKey", nArray);
        Object object = RQueuedMessage.computeResourceKey(aS400, this.path_, byArray);
        RQueuedMessage rQueuedMessage = new RQueuedMessage();
        try {
            rQueuedMessage.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        rQueuedMessage.setResourceKey(object);
        Object[] objectArray = openListAttributeMap_.getIDs();
        Object[] objectArray2 = openListAttributeMap_.getValues(objectArray, aS400, this.document_, string, nArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            rQueuedMessage.initializeAttributeValue(objectArray[i], objectArray2[i]);
        }
        Integer n = (Integer)this.getSelectionValue(FORMATTING_CHARACTERS);
        if (n.equals(SUBSTITUTE_FORMATTING_CHARACTERS)) {
            charSequence = (String)rQueuedMessage.getAttributeValue("MESSAGE_HELP");
            charSequence = MessageFile.substituteFormattingCharacters((String)charSequence);
            rQueuedMessage.initializeAttributeValue("MESSAGE_HELP", charSequence);
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append((String)rQueuedMessage.getAttributeValue("MESSAGE_ID"));
        ((StringBuffer)charSequence).append('(');
        ((StringBuffer)charSequence).append(Presentation.bytesToHex((byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY")));
        ((StringBuffer)charSequence).append(')');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.path_);
        stringBuffer.append('-');
        stringBuffer.append(((StringBuffer)charSequence).toString());
        Presentation presentation = rQueuedMessage.getPresentation();
        presentation.setName(((StringBuffer)charSequence).toString());
        presentation.setFullName(stringBuffer.toString());
        presentation.setValue("Description Text", rQueuedMessage.getAttributeValue("MESSAGE_TEXT"));
        presentation.setValue("Help Text", rQueuedMessage.getAttributeValue("MESSAGE_HELP"));
        return rQueuedMessage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            NEWEST = new byte[]{-1, -1, -1, -1};
            OLDEST = new byte[]{0, 0, 0, 0};
            NO_FORMATTING = new Integer(0);
            RETURN_FORMATTING_CHARACTERS = new Integer(1);
            SUBSTITUTE_FORMATTING_CHARACTERS = new Integer(2);
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selectionMap_ = new ProgramMap();
            selections_.add(FORMATTING_CHARACTERS, class$java$lang$Integer == null ? (class$java$lang$Integer = RMessageQueue.class$("java.lang.Integer")) : class$java$lang$Integer, false, new Integer[]{NO_FORMATTING, RETURN_FORMATTING_CHARACTERS, SUBSTITUTE_FORMATTING_CHARACTERS}, NO_FORMATTING, true);
            selections_.add(LIST_DIRECTION, class$java$lang$String == null ? (class$java$lang$String = RMessageQueue.class$("java.lang.String")) : class$java$lang$String, false, new String[]{NEXT, PREVIOUS}, NEXT, true);
            selectionMap_.add(LIST_DIRECTION, null, "messageSelectionInformation.listDirection");
            selections_.add(REPLACEMENT_DATA, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RMessageQueue.class$("java.lang.Boolean")) : class$java$lang$Boolean, false, null, Boolean.TRUE, false);
            selections_.add(SELECTION_CRITERIA, class$java$lang$String == null ? (class$java$lang$String = RMessageQueue.class$("java.lang.String")) : class$java$lang$String, false, new String[]{ALL, MESSAGES_NEED_REPLY, SENDERS_COPY_NEED_REPLY, MESSAGES_NO_NEED_REPLY}, ALL, true);
            selectionMap_.add(SELECTION_CRITERIA, null, "messageSelectionInformation.selectionCriteria");
            selections_.add(SEVERITY_CRITERIA, class$java$lang$Integer == null ? (class$java$lang$Integer = RMessageQueue.class$("java.lang.Integer")) : class$java$lang$Integer, false, null, new Integer(0), false);
            selectionMap_.add(SEVERITY_CRITERIA, null, "messageSelectionInformation.severityCriteria");
            selections_.add(SORT_CRITERIA, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RMessageQueue.class$("java.lang.Boolean")) : class$java$lang$Boolean, false, null, Boolean.FALSE, false);
            selectionMap_.add((Object)SORT_CRITERIA, null, "sortInformation", new BooleanValueMap("0", "1"));
            selections_.add(STARTING_USER_MESSAGE_KEY, array$B == null ? (array$B = RMessageQueue.class$("[B")) : array$B, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add((Object)STARTING_USER_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKeys", new int[]{0});
            selections_.add(STARTING_WORKSTATION_MESSAGE_KEY, array$B == null ? (array$B = RMessageQueue.class$("[B")) : array$B, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add((Object)STARTING_WORKSTATION_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKeys", new int[]{1});
            openListAttributeMap_ = new ProgramMap();
            openListAttributeMap_.add("MESSAGE_SEVERITY", null, "receiverVariable.messageSeverity");
            openListAttributeMap_.add("MESSAGE_ID", null, "receiverVariable.messageIdentifier");
            openListAttributeMap_.add((Object)"MESSAGE_TYPE", null, "receiverVariable.messageType", new IntegerValueMap());
            openListAttributeMap_.add("MESSAGE_KEY", null, "receiverVariable.messageKey");
            openListAttributeMap_.add((Object)PRESENTATION_KEY_, null, "receiverVariable.messageQueue", new QualifiedValueMap(20, "MSGQ"));
            openListAttributeMap_.add((Object)"MESSAGE_FILE", null, "receiverVariable.messageFile", new QualifiedValueMap(20, "MSGF"));
            openListAttributeMap_.add((Object)"DATE_SENT", null, "receiverVariable.dateAndTimeSent", new DateValueMap(13));
            openListAttributeMap_.add("MESSAGE_TEXT", null, "receiverVariable.message.data");
            openListAttributeMap_.add((Object)"SENDER_JOB_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(0, 10, true));
            openListAttributeMap_.add((Object)"SENDER_JOB_NUMBER", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(20, 6, true));
            openListAttributeMap_.add((Object)"SENDER_USER_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(10, 10, true));
            openListAttributeMap_.add("SENDING_PROGRAM_NAME", null, "receiverVariable.sendingProgramName.data");
            openListAttributeMap_.add("REPLY_STATUS", null, "receiverVariable.replyStatus.data");
            openListAttributeMap_.add("DEFAULT_REPLY", null, "receiverVariable.defaultReply.data");
            openListAttributeMap_.add("MESSAGE_HELP", null, "receiverVariable.messageHelp.data");
            receiveAttributeMap_ = new ProgramMap();
            receiveAttributeMap_.add("MESSAGE_SEVERITY", null, "messageInformation.messageSeverity");
            receiveAttributeMap_.add("MESSAGE_ID", null, "messageInformation.messageID");
            receiveAttributeMap_.add((Object)"MESSAGE_TYPE", null, "messageInformation.messageType", new IntegerValueMap());
            receiveAttributeMap_.add("MESSAGE_KEY", null, "messageInformation.messageKey");
            receiveAttributeMap_.add((Object)"MESSAGE_FILE", null, "messageInformation.messageFile", new QualifiedValueMap(20, "MSGF"));
            receiveAttributeMap_.add("SENDER_JOB_NAME", null, "messageInformation.sendingJob");
            receiveAttributeMap_.add("SENDER_JOB_NUMBER", null, "messageInformation.sendingJobsNumber");
            receiveAttributeMap_.add("SENDER_USER_NAME", null, "messageInformation.sendingUserProfile");
            receiveAttributeMap_.add("SENDING_PROGRAM_NAME", null, "messageInformation.sendingProgramName");
            receiveAttributeMap_.add((Object)"DATE_SENT", null, "messageInformation.dateAndTimeSent", new DateValueMap(13));
            receiveAttributeMap_.add("ALERT_OPTION", null, "messageInformation.alertOption");
            receiveAttributeMap_.add("MESSAGE_HELP", null, "messageInformation.messageHelp");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
        BLANK_KEY = new byte[]{64, 64, 64, 64};
    }
}

