/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.beans.PropertyVetoException;

public class DefaultProfileTokenProvider
implements ProfileTokenProvider {
    private static final int UNINITIALIZED = -1;
    private AS400 system_;
    private int timeoutInterval_ = -1;
    private String userId_ = null;
    private int tokenType_ = -1;
    private Object extendedInfo_;

    public DefaultProfileTokenProvider() {
        this(new AS400());
    }

    public DefaultProfileTokenProvider(AS400 aS400) {
        this.setSystem(aS400);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setSystem(AS400 aS400) {
        this.system_ = aS400;
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval_;
    }

    public void setTimeoutInterval(int n) {
        this.timeoutInterval_ = n;
    }

    public int getTokenType() {
        return this.tokenType_;
    }

    public void setTokenType(int n) {
        if (n != 1 && n != 3 && n != 2) {
            throw new ExtendedIllegalArgumentException("tokenType", 2);
        }
        this.tokenType_ = n;
    }

    public String getUserId() {
        return this.userId_;
    }

    public void setUserId(String string) {
        if (null == string || 0 == string.length()) {
            throw new ExtendedIllegalArgumentException("userId", 1);
        }
        this.userId_ = string;
    }

    public Object getExtendedInfo() {
        return this.extendedInfo_;
    }

    public void setPassword(String string) {
        if (string == null) {
            throw new NullPointerException("password");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("password", 1);
        }
        this.setExtendedInfo(string);
    }

    public void setPassword(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("password");
        }
        if (cArray.length == 0) {
            throw new ExtendedIllegalArgumentException("password", 1);
        }
        this.setExtendedInfo(cArray);
    }

    public void setPasswordSpecialValue(int n) {
        if (n != 1 && n != 2) {
            throw new ExtendedIllegalArgumentException("specialValue", 2);
        }
        this.setExtendedInfo(new Integer(n));
    }

    protected void setExtendedInfo(Object object) {
        this.extendedInfo_ = object;
    }

    public ProfileTokenCredential create() throws AS400SecurityException {
        this.checkFieldSet(this.system_, "system");
        this.checkFieldSet(this.timeoutInterval_, "timeoutInterval");
        this.checkFieldSet(this.userId_, "userId");
        this.checkFieldSet(this.tokenType_, "tokenType");
        this.checkFieldSet(this.extendedInfo_, "extendedInfo");
        try {
            ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
            profileTokenCredential.setSystem(this.getSystem());
            profileTokenCredential.setTimeoutInterval(this.getTimeoutInterval());
            profileTokenCredential.setTokenType(this.getTokenType());
            Object object = this.getExtendedInfo();
            if (object instanceof Integer) {
                profileTokenCredential.setToken(this.getUserId(), (int)((Integer)object));
            } else if (object instanceof String) {
                profileTokenCredential.setTokenExtended(this.getUserId(), (String)object);
            } else if (object instanceof char[]) {
                profileTokenCredential.setTokenExtended(this.getUserId(), (char[])object);
            } else {
                throw new ExtendedIllegalStateException("extendedInfo", 6);
            }
            return profileTokenCredential;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
    }

    protected final void checkFieldSet(Object object, String string) {
        if (null == object) {
            throw new ExtendedIllegalStateException(string, 4);
        }
    }

    protected final void checkFieldSet(int n, String string) {
        if (n < 0) {
            throw new ExtendedIllegalStateException(string, 4);
        }
    }
}

