/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.vaccess.ResourceLoader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceProperties
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String RESOURCE_GENERAL_TAB_ = ResourceLoader.getText("RESOURCE_GENERAL_TAB");
    private static final Object FIRST_TAB_KEY_ = new Integer(0);
    private boolean editable_ = false;
    private int tabCounter_ = 0;
    private Hashtable tabPropertyIDs_ = new Hashtable();
    private Hashtable tabLabels_ = new Hashtable();

    public ResourceProperties() {
        this(new Object[0], RESOURCE_GENERAL_TAB_, true);
    }

    public ResourceProperties(String string, boolean bl) {
        this(new Object[0], string, bl);
    }

    public ResourceProperties(Object[] objectArray, String string, boolean bl) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIDs");
        }
        if (string == null) {
            throw new NullPointerException("firstTabLabel");
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                throw new NullPointerException("propertyIDs[" + i + "]");
            }
            vector.addElement(objectArray[i]);
        }
        this.tabPropertyIDs_.put(FIRST_TAB_KEY_, vector);
        this.tabLabels_.put(FIRST_TAB_KEY_, string);
        this.editable_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(Object object) {
        if (object == null) {
            throw new NullPointerException("propertyID");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            ((Vector)this.tabPropertyIDs_.get(FIRST_TAB_KEY_)).addElement(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("propertyID");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer n2 = new Integer(n);
            if (!this.tabPropertyIDs_.containsKey(n2)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            ((Vector)this.tabPropertyIDs_.get(n2)).addElement(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Vector vector = (Vector)this.tabPropertyIDs_.get(FIRST_TAB_KEY_);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                vector.addElement(objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(int n, Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer n2 = new Integer(n);
            if (!this.tabPropertyIDs_.containsKey(n2)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            Vector vector = (Vector)this.tabPropertyIDs_.get(n2);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                vector.addElement(objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTab(String string) {
        if (string == null) {
            throw new NullPointerException("label");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            ++this.tabCounter_;
            Integer n = new Integer(this.tabCounter_);
            this.tabPropertyIDs_.put(n, new Vector());
            this.tabLabels_.put(n, string);
            return this.tabCounter_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTab(String string, Object[] objectArray) {
        if (string == null) {
            throw new NullPointerException("label");
        }
        if (objectArray == null) {
            throw new NullPointerException("propertyIDs");
        }
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new NullPointerException("propertyIDs[" + i + "]");
                }
                vector.addElement(objectArray[i]);
            }
            ++this.tabCounter_;
            Integer n = new Integer(this.tabCounter_);
            this.tabPropertyIDs_.put(n, vector);
            this.tabLabels_.put(n, string);
            return this.tabCounter_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(int n) {
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer n2 = new Integer(n);
            if (!this.tabLabels_.containsKey(n2)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            return (String)this.tabLabels_.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getProperties(int n) {
        ResourceProperties resourceProperties = this;
        synchronized (resourceProperties) {
            Integer n2 = new Integer(n);
            if (!this.tabPropertyIDs_.containsKey(n2)) {
                throw new ExtendedIllegalArgumentException("tab", 2);
            }
            Vector vector = (Vector)this.tabPropertyIDs_.get(n2);
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public int getTabCount() {
        return this.tabCounter_ + 1;
    }

    public boolean isEditable() {
        return this.editable_;
    }

    public void setEditable(boolean bl) {
        this.editable_ = bl;
    }
}

